<x-app-layout>
    <section class="py-4">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h4 mb-0">New Item</h1>
                <a href="{{ route('admin.items.index') }}" class="btn btn-outline-primary rounded-pill">Back</a>
            </div>

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card shadow-sm">
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.items.store') }}" class="row g-3">
                        @csrf
                        <div class="col-md-6">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Slug</label>
                            <input type="text" name="slug" class="form-control" value="{{ old('slug') }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">SKU</label>
                            <input type="text" name="sku" class="form-control" value="{{ old('sku') }}" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Category</label>
                            <select name="category_id" class="form-select" required>
                                @foreach($categories as $cat)
                                    <option value="{{ $cat->id }}" @selected(old('category_id')==$cat->id)>{{ $cat->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Season</label>
                            <select name="season_id" class="form-select">
                                <option value="">— None —</option>
                                @foreach($seasons as $s)
                                    <option value="{{ $s->id }}" @selected(old('season_id', isset($prefillSeason)?$prefillSeason->id:null)==$s->id)>{{ $s->code }} — {{ $s->label }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description</label>
                            <textarea name="description" class="form-control" rows="4">{{ old('description') }}</textarea>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Attributes</label>
                            <div class="row g-2 align-items-end">
                                @for($i=0;$i<5;$i++)
                                    <div class="col-md-4">
                                        <input type="text" class="form-control" name="attr_name[]" placeholder="Key (e.g., weight)" value="{{ old('attr_name.'.$i) }}">
                                    </div>
                                    <div class="col-md-6">
                                        <input type="text" class="form-control" name="attr_value[]" placeholder="Value (e.g., 2/30)" value="{{ old('attr_value.'.$i) }}">
                                    </div>
                                @endfor
                            </div>
                            <small class="text-muted">Optional key/value pairs (e.g., weight, gauge, type).</small>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Colour Grid Columns</label>
                            <input type="number" name="colour_grid_columns" class="form-control" min="1" max="8" value="{{ old('colour_grid_columns', 3) }}">
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-check">
                                <input type="hidden" name="has_colourways" value="0">
                                <input class="form-check-input" type="checkbox" name="has_colourways" id="has_colourways" value="1" @checked(old('has_colourways', 1))>
                                <label class="form-check-label" for="has_colourways">Has Colourways</label>
                            </div>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-check">
                                <input type="hidden" name="is_active" value="0">
                                <input class="form-check-input" type="checkbox" name="is_active" id="is_active" value="1" @checked(old('is_active', 1))>
                                <label class="form-check-label" for="is_active">Active</label>
                            </div>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-primary rounded-pill">Create Item</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>


