@extends('layouts.frontend')

@section('meta_title', 'Yarn Care Guide - How to Wash & Store Your Yarn - Yarn Store')
@section('meta_description', 'Learn how to properly care for, wash, and store your yarn and finished projects. Expert tips for maintaining the quality and longevity of your knitwear.')
@section('meta_keywords', 'yarn care, how to wash wool, yarn storage, knitwear care, hand washing yarn, blocking knits')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <span>Care Guide</span>
            </nav>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-lg-8 mx-auto text-center">
            <h1 class="display-4 fw-bold mb-3">Yarn Care Guide</h1>
            <p class="lead text-muted">
                Learn how to care for your yarn and finished projects to keep them beautiful for years to come
            </p>
        </div>
    </div>

    <!-- Washing Instructions -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Washing Your Knitwear</h2>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Hand Washing (Recommended)</h3>
                <ol class="text-muted">
                    <li class="mb-2">Fill a basin with cool or lukewarm water (never hot)</li>
                    <li class="mb-2">Add a gentle wool wash or baby shampoo</li>
                    <li class="mb-2">Submerge the item and gently squeeze (don't wring or rub)</li>
                    <li class="mb-2">Let soak for 10-15 minutes</li>
                    <li class="mb-2">Rinse thoroughly in water of the same temperature</li>
                    <li class="mb-2">Gently squeeze out excess water (don't twist)</li>
                    <li class="mb-2">Roll in a towel to remove more water</li>
                    <li class="mb-2">Lay flat to dry on a clean towel, reshaping as needed</li>
                </ol>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Machine Washing</h3>
                <p class="text-muted mb-3">
                    Only if the yarn label specifically says "machine washable":
                </p>
                <ul class="text-muted">
                    <li class="mb-2">Use a mesh laundry bag for protection</li>
                    <li class="mb-2">Select gentle/delicate cycle</li>
                    <li class="mb-2">Use cool or lukewarm water</li>
                    <li class="mb-2">Use wool-specific detergent</li>
                    <li class="mb-2">Skip the spin cycle if possible</li>
                    <li class="mb-2">Never use fabric softener</li>
                    <li class="mb-2">Lay flat to dry - never tumble dry unless specifically indicated</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Fiber-Specific Care -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Care by Fiber Type</h2>
        </div>

        <div class="col-12">
            <div class="ys-card p-4 mb-3">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <h3 class="h6 fw-bold mb-0">Wool & Merino</h3>
                    </div>
                    <div class="col-md-9">
                        <p class="text-muted small mb-0">
                            Hand wash in cool water, lay flat to dry. Avoid temperature changes to prevent felting. 
                            Can be gently steamed to refresh between washes.
                        </p>
                    </div>
                </div>
            </div>

            <div class="ys-card p-4 mb-3">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <h3 class="h6 fw-bold mb-0">Cotton</h3>
                    </div>
                    <div class="col-md-9">
                        <p class="text-muted small mb-0">
                            Can typically be machine washed on gentle cycle. May shrink slightly on first wash. 
                            Can stretch when wet - support when lifting. Reshape while drying.
                        </p>
                    </div>
                </div>
            </div>

            <div class="ys-card p-4 mb-3">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <h3 class="h6 fw-bold mb-0">Alpaca & Mohair</h3>
                    </div>
                    <div class="col-md-9">
                        <p class="text-muted small mb-0">
                            Hand wash in cool water with gentle wool wash. Very gentle handling required. 
                            Lay flat to dry away from heat. Can be brushed gently to restore fluffiness.
                        </p>
                    </div>
                </div>
            </div>

            <div class="ys-card p-4 mb-3">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <h3 class="h6 fw-bold mb-0">Silk</h3>
                    </div>
                    <div class="col-md-9">
                        <p class="text-muted small mb-0">
                            Hand wash in cool water with mild detergent. Never wring. Roll in towel to remove water. 
                            Lay flat or hang to dry away from direct sunlight.
                        </p>
                    </div>
                </div>
            </div>

            <div class="ys-card p-4">
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <h3 class="h6 fw-bold mb-0">Acrylic</h3>
                    </div>
                    <div class="col-md-9">
                        <p class="text-muted small mb-0">
                            Usually machine washable and dryable. Check label for specific instructions. 
                            May pill with wear - use a fabric shaver to remove pills.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Storage -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Storing Your Yarn & Projects</h2>
        </div>

        <div class="col-lg-4 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Unused Yarn</h3>
                <ul class="text-muted small">
                    <li class="mb-2">Store in a cool, dry place away from direct sunlight</li>
                    <li class="mb-2">Keep in breathable containers or bags</li>
                    <li class="mb-2">Avoid plastic bags for natural fibers (can trap moisture)</li>
                    <li class="mb-2">Keep labels attached for reference</li>
                    <li class="mb-2">Use lavender or cedar to deter moths</li>
                </ul>
            </div>
        </div>

        <div class="col-lg-4 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Finished Items</h3>
                <ul class="text-muted small">
                    <li class="mb-2">Clean before storing</li>
                    <li class="mb-2">Fold rather than hang (prevents stretching)</li>
                    <li class="mb-2">Use acid-free tissue paper between folds</li>
                    <li class="mb-2">Store in breathable cotton bags</li>
                    <li class="mb-2">Avoid cedar chests (oils can stain)</li>
                    <li class="mb-2">Check periodically for pests</li>
                </ul>
            </div>
        </div>

        <div class="col-lg-4 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Moth Prevention</h3>
                <ul class="text-muted small">
                    <li class="mb-2">Clean items before storage (moths are attracted to dirt)</li>
                    <li class="mb-2">Use natural repellents: lavender, cedar, or mint</li>
                    <li class="mb-2">Seal items in airtight containers if possible</li>
                    <li class="mb-2">Vacuum storage areas regularly</li>
                    <li class="mb-2">Freeze yarn for 72 hours if you suspect moths</li>
                    <li class="mb-2">Check stored items every few months</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Blocking -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Blocking Your Projects</h2>
        </div>

        <div class="col-lg-8 mx-auto">
            <div class="ys-card p-4">
                <p class="text-muted mb-3">
                    Blocking is the process of wetting or steaming your finished project and shaping it to the desired 
                    dimensions. This helps even out stitches and gives a professional finish.
                </p>

                <h3 class="h6 fw-semibold mb-2">Wet Blocking</h3>
                <ol class="text-muted small mb-4">
                    <li class="mb-2">Soak item in cool water with wool wash for 15-20 minutes</li>
                    <li class="mb-2">Gently squeeze out excess water</li>
                    <li class="mb-2">Lay on blocking mats or towels</li>
                    <li class="mb-2">Pin to desired shape and measurements</li>
                    <li class="mb-2">Allow to dry completely (24-48 hours)</li>
                </ol>

                <h3 class="h6 fw-semibold mb-2">Steam Blocking</h3>
                <p class="text-muted small mb-3">
                    Good for acrylic and some wool blends. Hold a steamer or iron (on steam setting) 
                    1-2 inches above the fabric. Never let the iron touch the fabric directly.
                </p>

                <h3 class="h6 fw-semibold mb-2">Spray Blocking</h3>
                <p class="text-muted small mb-0">
                    For items that don't need reshaping. Pin to desired shape, spray with water, and let dry.
                </p>
            </div>
        </div>
    </div>

    <!-- Troubleshooting -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Common Problems & Solutions</h2>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-danger);">Item Shrank</h3>
                <p class="text-muted mb-2 small">
                    <strong>Prevention:</strong> Always check care labels, use cool water, avoid temperature changes.
                </p>
                <p class="text-muted small">
                    <strong>Fix:</strong> Soak in hair conditioner for 30 minutes, then gently stretch while wet. 
                    Pin to shape and dry. May not restore to original size but can help.
                </p>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-danger);">Pilling</h3>
                <p class="text-muted mb-2 small">
                    <strong>Prevention:</strong> Wash inside out, avoid friction areas, choose quality yarns.
                </p>
                <p class="text-muted small">
                    <strong>Fix:</strong> Use a fabric shaver or sweater stone. Pull pills up and away, 
                    don't cut with scissors (can damage fabric).
                </p>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-danger);">Stretched Out</h3>
                <p class="text-muted mb-2 small">
                    <strong>Prevention:</strong> Lay flat to dry, don't hang when wet, support weight when handling.
                </p>
                <p class="text-muted small">
                    <strong>Fix:</strong> Wash in slightly warmer water than usual (but not hot), 
                    reshape to correct size while drying. May need to reblock.
                </p>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-danger);">Moth Damage</h3>
                <p class="text-muted mb-2 small">
                    <strong>Prevention:</strong> Clean before storage, use natural repellents, store properly.
                </p>
                <p class="text-muted small">
                    <strong>Fix:</strong> Small holes can sometimes be darned. For larger damage, 
                    consider decorative patches or embroidery to cover affected areas.
                </p>
            </div>
        </div>
    </div>

    <!-- CTA -->
    <div class="row">
        <div class="col-lg-8 mx-auto text-center">
            <div class="ys-card p-5" style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-dark) 100%);">
                <h2 class="h3 fw-bold mb-3 text-white">Questions About Yarn Care?</h2>
                <p class="text-white mb-4">
                    Our team is here to help with any questions about caring for your yarn and projects.
                </p>
                <a href="{{ route('contact') }}" class="btn btn-light btn-lg">
                    Contact Us
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

