<?php

use App\Models\User;
use Firebase\JWT\JWT;
use Tests\TestCase;

class AuthTest extends TestCase
{
    public function test_auth_via_apple_issues_token(): void
    {
        $payload = ['sub' => 'apple-sub-123'];
        $token = JWT::urlsafeB64Encode('header').'.'.JWT::urlsafeB64Encode(json_encode($payload)).'.sig';

        $resp = $this->postJson('/v1/auth/apple', [
            'identity_token' => (string) $token,
        ]);
        $resp->assertCreated()->assertJsonStructure(['token', 'token_type', 'expires_at']);
    }
}


