<?php

use App\Models\User;
use Firebase\JWT\JWT;

it('auth via apple issues token', function () {
    $payload = ['sub' => 'apple-sub-123'];
    $token = JWT::urlsafeB64Encode('header').'.'.JWT::urlsafeB64Encode(json_encode($payload)).'.sig';

    $resp = $this->postJson('/v1/auth/apple', [
        'identity_token' => (string) $token,
    ]);
    $resp->assertCreated()->assertJsonStructure(['token', 'token_type', 'expires_at']);
});


