<?php

use App\Models\User;
use Lcobucci\JWT\Configuration;

it('auth via apple issues token', function () {
    $config = Configuration::forUnsecuredSigner();
    $token = $config->builder()->relatedTo('apple-sub-123')->issuedBy('test')->getToken($config->signer(), $config->signingKey());

    $resp = $this->postJson('/v1/auth/apple', [
        'identity_token' => (string) $token,
    ]);
    $resp->assertCreated()->assertJsonStructure(['token', 'token_type', 'expires_at']);
});


