<div>
    <!-- Flash Messages -->
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    <li class="breadcrumb-item"><a href="{{ route('admin.orders') }}" wire:navigate>Orders</a></li>
                    <li class="breadcrumb-item active">#{{ $order->order_number }}</li>
                </ol>
            </nav>
            <h1 class="h3 mb-1">Order #{{ $order->order_number }}</h1>
            <p class="text-muted mb-0">
                Placed on {{ $order->created_at->format('M j, Y \a\t g:i A') }}
            </p>
        </div>
        <div class="btn-group">
            @if($editing)
                <button wire:click="save" class="btn btn-success">
                    <i class="bi bi-check-lg me-2"></i>Save Changes
                </button>
                <button wire:click="toggleEdit" class="btn btn-outline-secondary">
                    <i class="bi bi-x-lg me-2"></i>Cancel
                </button>
            @else
                <button wire:click="toggleEdit" class="btn btn-primary">
                    <i class="bi bi-pencil me-2"></i>Edit Order
                </button>
                <button wire:click="deleteOrder" 
                        class="btn btn-outline-danger"
                        onclick="return confirm('Are you sure you want to delete this order? This action cannot be undone.')">
                    <i class="bi bi-trash me-2"></i>Delete
                </button>
            @endif
        </div>
    </div>

    <div class="row">
        <!-- Order Details -->
        <div class="col-lg-8 mb-4">
            <!-- Order Status -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Order Status</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Status</label>
                            @if($editing)
                                <select wire:model="status" class="form-select">
                                    <option value="pending">Pending</option>
                                    <option value="confirmed">Confirmed</option>
                                    <option value="processing">Processing</option>
                                    <option value="shipped">Shipped</option>
                                    <option value="delivered">Delivered</option>
                                    <option value="cancelled">Cancelled</option>
                                </select>
                            @else
                                @php
                                    $statusColors = [
                                        'pending' => 'warning',
                                        'confirmed' => 'info',
                                        'processing' => 'primary',
                                        'shipped' => 'success',
                                        'delivered' => 'success',
                                        'cancelled' => 'danger',
                                    ];
                                @endphp
                                <div>
                                    <span class="badge bg-{{ $statusColors[$order->status] ?? 'secondary' }} fs-6">
                                        {{ ucfirst($order->status) }}
                                    </span>
                                </div>
                            @endif
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Tracking Number</label>
                            @if($editing)
                                <input type="text" wire:model="trackingNumber" class="form-control" placeholder="Enter tracking number">
                            @else
                                <div class="form-control-plaintext">
                                    {{ $order->tracking_number ?? 'Not provided' }}
                                </div>
                            @endif
                        </div>

                        @if($order->shipped_at)
                            <div class="col-md-6">
                                <label class="form-label">Shipped At</label>
                                <div class="form-control-plaintext">
                                    {{ $order->shipped_at->format('M j, Y \a\t g:i A') }}
                                </div>
                            </div>
                        @endif

                        @if($order->delivered_at)
                            <div class="col-md-6">
                                <label class="form-label">Delivered At</label>
                                <div class="form-control-plaintext">
                                    {{ $order->delivered_at->format('M j, Y \a\t g:i A') }}
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Order Items -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Order Items</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Item</th>
                                    <th>Colourway</th>
                                    <th class="text-center">Quantity</th>
                                    <th class="text-end">Unit Price</th>
                                    <th class="text-end">Line Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($order->orderLines as $line)
                                    <tr>
                                        <td>
                                            <div class="fw-semibold">{{ $line->item_name }}</div>
                                            @if($line->item_sku)
                                                <small class="text-muted">SKU: {{ $line->item_sku }}</small>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                @if($line->colourway && $line->colourway->image)
                                                    <img src="{{ asset('storage/' . $line->colourway->image) }}" 
                                                         alt="{{ $line->colourway_name }}"
                                                         class="rounded me-2"
                                                         style="width: 40px; height: 40px; object-fit: cover;">
                                                @endif
                                                <span>{{ $line->colourway_name ?? 'N/A' }}</span>
                                            </div>
                                        </td>
                                        <td class="text-center">{{ $line->quantity }}</td>
                                        <td class="text-end">
                                            <div>£{{ number_format($line->initial_unit_price, 2) }}</div>
                                            @if($line->invoiced_unit_price && $line->invoiced_unit_price != $line->initial_unit_price)
                                                <small class="text-success">
                                                    Final: £{{ number_format($line->invoiced_unit_price, 2) }}
                                                </small>
                                            @endif
                                        </td>
                                        <td class="text-end">
                                            <div>£{{ number_format($line->initial_line_total, 2) }}</div>
                                            @if($line->invoiced_line_total && $line->invoiced_line_total != $line->initial_line_total)
                                                <small class="text-success">
                                                    Final: £{{ number_format($line->invoiced_line_total, 2) }}
                                                </small>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <td colspan="4" class="text-end fw-semibold">Subtotal:</td>
                                    <td class="text-end">£{{ number_format($order->initial_subtotal, 2) }}</td>
                                </tr>
                                <tr>
                                    <td colspan="4" class="text-end fw-semibold">Tax:</td>
                                    <td class="text-end">£{{ number_format($order->initial_tax_amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <td colspan="4" class="text-end fw-semibold">Shipping:</td>
                                    <td class="text-end">£{{ number_format($order->initial_shipping_amount, 2) }}</td>
                                </tr>
                                <tr class="table-primary">
                                    <td colspan="4" class="text-end fw-bold">Total:</td>
                                    <td class="text-end fw-bold">£{{ number_format($order->initial_total_amount, 2) }}</td>
                                </tr>
                                @if($order->invoiced_total_amount && $order->invoiced_total_amount != $order->initial_total_amount)
                                    <tr class="table-success">
                                        <td colspan="4" class="text-end fw-bold">Final Invoiced Total:</td>
                                        <td class="text-end fw-bold">£{{ number_format($order->invoiced_total_amount, 2) }}</td>
                                    </tr>
                                @endif
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Invoice Details -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Invoice Details</h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Zoho Invoice Number</label>
                            @if($editing)
                                <input type="text" wire:model="zohoInvoiceNumber" class="form-control" placeholder="Enter Zoho invoice number">
                            @else
                                <div class="form-control-plaintext">
                                    {{ $order->zoho_invoice_number ?? 'Not provided' }}
                                </div>
                            @endif
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Supplier Invoice Number</label>
                            @if($editing)
                                <input type="text" wire:model="supplierInvoiceNumber" class="form-control" placeholder="Enter supplier invoice number">
                            @else
                                <div class="form-control-plaintext">
                                    {{ $order->supplier_invoice_number ?? 'Not provided' }}
                                </div>
                            @endif
                        </div>

                        @if($editing)
                            <div class="col-12">
                                <h6 class="mt-2 mb-3">Final Invoiced Amounts</h6>
                            </div>
                            
                            <div class="col-md-6">
                                <label class="form-label">Invoiced Subtotal</label>
                                <div class="input-group">
                                    <span class="input-group-text">£</span>
                                    <input type="number" step="0.01" wire:model="invoicedSubtotal" class="form-control" placeholder="0.00">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Invoiced Tax</label>
                                <div class="input-group">
                                    <span class="input-group-text">£</span>
                                    <input type="number" step="0.01" wire:model="invoicedTaxAmount" class="form-control" placeholder="0.00">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Invoiced Shipping</label>
                                <div class="input-group">
                                    <span class="input-group-text">£</span>
                                    <input type="number" step="0.01" wire:model="invoicedShippingAmount" class="form-control" placeholder="0.00">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Invoiced Total</label>
                                <div class="input-group">
                                    <span class="input-group-text">£</span>
                                    <input type="number" step="0.01" wire:model="invoicedTotalAmount" class="form-control" placeholder="0.00">
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Notes -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Order Notes</h5>
                </div>
                <div class="card-body">
                    @if($editing)
                        <textarea wire:model="notes" class="form-control" rows="4" placeholder="Add notes about this order..."></textarea>
                    @else
                        <div class="form-control-plaintext">
                            {{ $order->notes ?? 'No notes' }}
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Customer Information -->
        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">Customer Information</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-3">
                        <div class="avatar-sm bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px;">
                            <span class="fs-5">{{ strtoupper(substr($order->user->name, 0, 1)) }}</span>
                        </div>
                        <div>
                            <div class="fw-semibold">{{ $order->user->name }}</div>
                            <small class="text-muted">{{ $order->user->email }}</small>
                        </div>
                    </div>
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.customers.show', $order->user->id) }}" 
                           class="btn btn-outline-primary btn-sm" 
                           wire:navigate>
                            <i class="bi bi-person me-2"></i>View Customer Profile
                        </a>
                    </div>
                </div>
            </div>

            <!-- Order Timeline -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Order Timeline</h5>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="timeline-item">
                            <div class="timeline-marker bg-success"></div>
                            <div class="timeline-content">
                                <div class="fw-semibold">Order Placed</div>
                                <small class="text-muted">{{ $order->created_at->format('M j, Y g:i A') }}</small>
                            </div>
                        </div>
                        
                        @if($order->shipped_at)
                            <div class="timeline-item">
                                <div class="timeline-marker bg-info"></div>
                                <div class="timeline-content">
                                    <div class="fw-semibold">Order Shipped</div>
                                    <small class="text-muted">{{ $order->shipped_at->format('M j, Y g:i A') }}</small>
                                    @if($order->tracking_number)
                                        <div><small><code>{{ $order->tracking_number }}</code></small></div>
                                    @endif
                                </div>
                            </div>
                        @endif
                        
                        @if($order->delivered_at)
                            <div class="timeline-item">
                                <div class="timeline-marker bg-success"></div>
                                <div class="timeline-content">
                                    <div class="fw-semibold">Order Delivered</div>
                                    <small class="text-muted">{{ $order->delivered_at->format('M j, Y g:i A') }}</small>
                                </div>
                            </div>
                        @endif

                        <div class="timeline-item">
                            <div class="timeline-marker bg-secondary"></div>
                            <div class="timeline-content">
                                <div class="fw-semibold">Last Updated</div>
                                <small class="text-muted">{{ $order->updated_at->format('M j, Y g:i A') }}</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline-item {
    position: relative;
    padding-bottom: 20px;
}

.timeline-item:not(:last-child):before {
    content: '';
    position: absolute;
    left: -23px;
    top: 15px;
    width: 2px;
    height: calc(100% - 5px);
    background: #dee2e6;
}

.timeline-marker {
    position: absolute;
    left: -28px;
    top: 5px;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    border: 2px solid white;
    box-shadow: 0 0 0 2px #dee2e6;
}

.timeline-content {
    padding-left: 0;
}
</style>

