@extends('layouts.frontend')

@section('meta_title', 'Search Results for "' . $query . '" - Yarn Store')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <span>Search</span>
            </nav>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-lg-8 mx-auto">
            <h1 class="h2 fw-bold mb-4">
                @if($query)
                    Search results for "{{ $query }}"
                @else
                    Search
                @endif
            </h1>
            
            <!-- Search Form -->
            <form action="{{ route('search') }}" method="GET" class="ys-search-bar mb-4">
                <input type="text" 
                       name="q" 
                       value="{{ $query }}" 
                       class="ys-search-input" 
                       placeholder="Search for yarns, colors, patterns..."
                       required>
                <button type="submit" class="ys-search-icon border-0 bg-transparent">
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" viewBox="0 0 16 16">
                        <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                    </svg>
                </button>
            </form>

            @if($query)
                <p class="text-muted">
                    Found {{ $products->total() }} {{ Str::plural('result', $products->total()) }}
                </p>
            @endif
        </div>
    </div>

    @if($products->count() > 0)
        <div class="product-grid">
            @foreach($products as $product)
                <a href="{{ route('product', $product->slug) }}" class="text-decoration-none">
                    <div class="product-card">
                        @if($product->primary_image)
                            <img src="{{ Storage::url($product->primary_image) }}" 
                                 alt="{{ $product->name }}" 
                                 class="product-image"
                                 loading="lazy">
                        @else
                            <div class="product-image d-flex align-items-center justify-content-center" 
                                 style="background-color: var(--ys-bg-tertiary);">
                                <span class="text-muted">No image</span>
                            </div>
                        @endif
                        <div class="product-info">
                            <h3 class="h6 fw-bold mb-2" style="color: var(--ys-text-primary);">
                                {{ $product->name }}
                            </h3>
                            <p class="text-muted small mb-2">
                                {{ $product->season->name }} • {{ $product->category->name }}
                            </p>
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="fw-bold" style="color: var(--ys-primary);">
                                    {{ $product->formatted_price }}
                                </span>
                                @if($product->colourways->count() > 0)
                                    <span class="text-muted small">
                                        {{ $product->colourways->count() }} {{ Str::plural('colour', $product->colourways->count()) }}
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                </a>
            @endforeach
        </div>

        <div class="d-flex justify-content-center mt-5">
            {{ $products->appends(['q' => $query])->links() }}
        </div>
    @elseif($query)
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="ys-card p-5 text-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" fill="var(--ys-text-muted)" class="mb-3" viewBox="0 0 16 16">
                        <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z"/>
                    </svg>
                    <h3 class="h4 fw-bold mb-3">No results found</h3>
                    <p class="text-muted mb-4">We couldn't find any products matching "{{ $query }}"</p>
                    <div class="d-flex gap-2 justify-content-center flex-wrap">
                        <a href="{{ route('collections') }}" class="btn btn-ys-primary">
                            Browse Collections
                        </a>
                        <a href="{{ route('home') }}" class="btn btn-ys-secondary">
                            Return Home
                        </a>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection

