@extends('layouts.shop')

@section('title', 'Shipping Information - Yarn Store')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">Shipping Information</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <div class="ys-card p-4">
                <h3 class="fw-bold mb-3">UK Shipping</h3>
                <p><strong>Free delivery on orders over £50</strong></p>
                <p>Orders under £50: £5.00 flat rate</p>
                <p>Typical delivery time: 2-4 business days</p>
                <p>All UK orders include tracking.</p>

                <h3 class="fw-bold mt-4 mb-3">International Shipping</h3>
                <p>We ship worldwide! Shipping costs calculated at checkout based on destination and order weight.</p>
                <p>Delivery times vary by location (typically 7-21 days).</p>
                <p>Note: International customers may be responsible for customs duties and taxes.</p>

                <h3 class="fw-bold mt-4 mb-3">Order Processing</h3>
                <p>Orders are typically processed and dispatched within 1-2 business days.</p>
                <p>Orders placed on weekends or holidays will be processed the next business day.</p>

                <h3 class="fw-bold mt-4 mb-3">Tracking Your Order</h3>
                <p>You'll receive a tracking number via email once your order ships.</p>
                <p>Track your order anytime through your account dashboard.</p>
            </div>
        </div>
    </div>
</div>
@endsection


