<x-app-layout>
    <!-- Hero Section -->
    <section class="categories-hero position-relative overflow-hidden bg-dark text-white py-5">
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center py-5">
                <div class="col-lg-8">
                    <div class="categories-hero-content" data-aos="fade-up">
                        <nav aria-label="breadcrumb" class="mb-4">
                            <ol class="breadcrumb breadcrumb-dark">
                                <li class="breadcrumb-item"><a href="{{ route('collections') }}" class="text-light text-decoration-none">Collections</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Categories</li>
                            </ol>
                        </nav>
                        
                        <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2">
                            <i class="bi bi-palette2 me-2"></i>Yarn Categories
                        </span>
                        
                        <h1 class="display-3 fw-light mb-4 text-white">
                            Yarn Categories
                            <span class="d-block fw-normal fs-2 mt-2 text-light">Browse by Type & Application</span>
                        </h1>
                        
                        <p class="lead mb-4 text-light opacity-90">
                            Explore our comprehensive range of luxury yarns organized by fibre type, weight, and intended use. 
                            From the softest cashmere to the most durable cotton, find the perfect yarn for your next project.
                        </p>
                        
                        <div class="d-flex gap-3 flex-wrap">
                            <a href="{{ route('collections') }}" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-arrow-left me-2"></i>Back to Collections
                            </a>
                            <a href="#categories" class="btn btn-primary btn-lg px-4 py-3">
                                <i class="bi bi-arrow-down me-2"></i>Explore Categories
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="categories-hero-image text-center" data-aos="fade-left">
                        <div class="categories-icon-large mb-4">
                            <i class="bi bi-palette2 display-1 text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="categories-hero-pattern"></div>
    </section>

    <!-- Categories Overview -->
    @if($categories->count() > 0)
        <section id="categories" class="py-5 bg-white">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">All Yarn Categories</h2>
                    <p class="text-muted lead">Discover the perfect yarn for every project and preference</p>
                </div>
                
                <div class="row g-4">
                    @foreach($categories as $index => $category)
                        <div class="col-lg-6" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="category-detail-card h-100 rounded shadow-sm border-0 overflow-hidden">
                                <div class="row g-0 h-100">
                                    <div class="col-md-4">
                                        <div class="category-image h-100 bg-light d-flex align-items-center justify-content-center">
                                            <i class="bi bi-palette2 display-2 text-primary"></i>
                                        </div>
                                    </div>
                                    <div class="col-md-8 p-4">
                                        <div class="d-flex justify-content-between align-items-start mb-3">
                                            <h4 class="fw-semibold mb-0">{{ $category->name }}</h4>
                                            <span class="badge bg-primary-subtle text-primary">{{ $category->items_count }} items</span>
                                        </div>
                                        
                                        @if($category->description)
                                            <p class="text-muted mb-3">{{ $category->description }}</p>
                                        @endif
                                        
                                        @if($category->items->count() > 0)
                                            <div class="category-items-preview mb-3">
                                                <h6 class="fw-semibold mb-2">Featured Items:</h6>
                                                <div class="row g-2">
                                                    @foreach($category->items->take(3) as $item)
                                                        <div class="col-6">
                                                            <div class="item-preview-card p-2 rounded bg-light border">
                                                                <small class="fw-medium d-block">{{ $item->name }}</small>
                                                                @if($item->season)
                                                                    <span class="badge bg-secondary-subtle text-secondary small">{{ $item->season->code }}</span>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            </div>
                                        @endif
                                        
                                        <div class="d-flex justify-content-between align-items-center">
                                            <small class="text-muted">
                                                @if($category->items->count() > 0)
                                                    {{ $category->items->count() }} {{ Str::plural('item', $category->items->count()) }} available
                                                @else
                                                    No items currently available
                                                @endif
                                            </small>
                                            <a href="#category-{{ $category->id }}" class="btn btn-outline-primary btn-sm">
                                                <i class="bi bi-arrow-right me-1"></i>View All
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Detailed Category Sections -->
    @if($categories->count() > 0)
        @foreach($categories as $categoryIndex => $category)
            @if($category->items->count() > 0)
                <section id="category-{{ $category->id }}" class="py-5 {{ $categoryIndex % 2 == 0 ? 'bg-light' : 'bg-white' }}">
                    <div class="container">
                        <div class="row align-items-center mb-5">
                            <div class="col-lg-8">
                                <div class="category-header" data-aos="fade-up">
                                    <h2 class="fw-light display-6 mb-3">{{ $category->name }}</h2>
                                    @if($category->description)
                                        <p class="text-muted lead mb-3">{{ $category->description }}</p>
                                    @endif
                                    <div class="d-flex gap-3 align-items-center">
                                        <span class="badge bg-primary px-3 py-2">{{ $category->items->count() }} {{ Str::plural('item', $category->items->count()) }}</span>
                                        @if($category->sort_order > 0)
                                            <span class="badge bg-secondary-subtle text-secondary px-3 py-2">Priority {{ $category->sort_order }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 text-center">
                                <div class="category-icon-large" data-aos="fade-left">
                                    <i class="bi bi-palette2 display-1 text-primary"></i>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row g-4">
                            @foreach($category->items as $itemIndex => $item)
                                <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ ($itemIndex + 1) * 100 }}">
                                    <div class="category-item-card h-100 rounded shadow-sm border-0 overflow-hidden bg-white">
                                        <div class="item-image position-relative">
                                            <div class="ratio ratio-4x3">
                                                @if($item->season && $item->season->image_path)
                                                    <img src="{{ $item->season->image_path }}" class="w-100 h-100 object-fit-cover" alt="{{ $item->name }}">
                                                @else
                                                    <div class="w-100 h-100 bg-light d-flex align-items-center justify-content-center">
                                                        <i class="bi bi-{{ $item->season && $item->season->half === 'AW' ? 'snow' : 'sun' }} display-4 text-muted"></i>
                                                    </div>
                                                @endif
                                            </div>
                                            @if($item->season)
                                                <div class="item-season-badge">
                                                    <span class="badge bg-primary">{{ $item->season->code }}</span>
                                                </div>
                                            @endif
                                        </div>
                                        
                                        <div class="item-content p-4">
                                            <h6 class="fw-semibold mb-2">{{ $item->name }}</h6>
                                            <p class="text-muted small mb-2">{{ $item->category->name }}</p>
                                            
                                            @if($item->description)
                                                <p class="text-muted small mb-3">{{ Str::limit($item->description, 80) }}</p>
                                            @endif
                                            
                                            @if($item->attributes)
                                                <div class="item-attributes mb-3">
                                                    @foreach($item->attributes as $key => $value)
                                                        @if(in_array($key, ['weight', 'gauge', 'type']))
                                                            <span class="badge bg-light text-dark me-1 mb-1">
                                                                {{ ucfirst($key) }}: {{ $value }}
                                                            </span>
                                                        @endif
                                                    @endforeach
                                                </div>
                                            @endif
                                            
                                            @if($item->colourways && $item->colourways->count() > 0)
                                                <div class="colourway-preview mb-3">
                                                    <small class="text-muted d-block mb-2">{{ $item->colourways->count() }} {{ Str::plural('colourway', $item->colourways->count()) }} available</small>
                                                    <div class="d-flex gap-1">
                                                        @foreach($item->colourways->take(5) as $colourway)
                                                            <div class="colourway-dot" title="{{ $colourway->name }}"></div>
                                                        @endforeach
                                                        @if($item->colourways->count() > 5)
                                                            <small class="text-muted ms-2">+{{ $item->colourways->count() - 5 }} more</small>
                                                        @endif
                                                    </div>
                                                </div>
                                            @endif
                                            
                                            <div class="d-flex justify-content-between align-items-center">
                                                <span class="text-primary fw-semibold small">{{ $item->sku }}</span>
                                                <a href="#" class="btn btn-outline-primary btn-sm">
                                                    <i class="bi bi-arrow-right"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </section>
            @endif
        @endforeach
    @endif

    <!-- Call to Action -->
    <section class="py-5 bg-primary text-white">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <div class="cta-content" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-4">Ready to Start Your Project?</h2>
                        <p class="lead mb-4 opacity-90">
                            Browse our collections by season or explore specific categories to find the perfect yarn for your next creation.
                        </p>
                        <div class="d-flex gap-3 justify-content-center flex-wrap">
                            <a href="{{ route('collections') }}" class="btn btn-light btn-lg px-4 py-3">
                                <i class="bi bi-collection me-2"></i>View Collections
                            </a>
                            <a href="/" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-house me-2"></i>Back to Home
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section id="newsletter" class="py-5 bg-dark text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center mb-5" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-3">Stay Connected</h2>
                        <p class="text-light opacity-90 lead">Be the first to know about new categories, exclusive releases, and expert yarn insights.</p>
                    </div>
                    <div class="card border-0 bg-transparent" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-body p-0">
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
