<?php

namespace App\Http\Controllers;

use App\Models\Consent;
use Illuminate\Http\Request;

class ConsentController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            'type' => ['required', 'string'],
            'version' => ['required', 'string'],
            'accepted_at' => ['required', 'date'],
        ]);
        $data['user_id'] = $request->user()->id;
        $consent = Consent::create($data);
        return response()->json($consent, 201);
    }
}


