<?php

namespace App\Http\Livewire\Sales\Orders;

use Livewire\Component;
use Livewire\Attributes\On;
use App\Models\CustomerOrders;
use Livewire\Attributes\Computed;
use App\Models\CustomerOrderLines;
use App\Http\Livewire\BaseComponent;
use App\Livewire\Forms\OrdersEditQuickAddForm;

class OrdersEditQuickadd extends BaseComponent
{
    public $orderID;

    public OrdersEditQuickAddForm $form;

    #[On('remove-item')]
    public function removeItem($item){
        $this->form->removeItem($item);
    }

    #[On('restore-item')]
    public function restoreItem($item){
        $this->form->restoreItem($item);
    }

    public function removeSize($s){
        $this->form->removeSize($s);
    }

    public function addSize(){
        $this->form->addSize();
    }

    public function addCustSizes(){
        $this->form->addCustSizes();
    }

    public function mount(){
        $this->form->open($this->orderID);
        // dd();
    }

    public function render()
    {
        return view('livewire.sales.orders.orders-edit-quickadd-dev');
    }

    #[Computed]
    public function readOnly(){
        return $this->form->readOnly();
    }

    #[On('save-order')]
    public function save(){
        $this->form->save();
    }
}
