const db = require('./src/db-multi-tenant');

async function fixConstraint() {
  try {
    console.log('Checking subscription_status constraint...\n');
    
    // Check current constraint
    const constraintCheck = await db.pool.query(`
      SELECT conname, pg_get_constraintdef(oid) as definition
      FROM pg_constraint 
      WHERE conrelid = 'users'::regclass 
      AND contype = 'c'
      AND conname LIKE '%subscription_status%';
    `);
    
    if (constraintCheck.rows.length > 0) {
      console.log('Current constraint:');
      console.log(constraintCheck.rows[0].definition);
      console.log('');
      
      // Drop the old constraint
      const constraintName = constraintCheck.rows[0].conname;
      console.log(`Dropping constraint: ${constraintName}`);
      await db.pool.query(`ALTER TABLE users DROP CONSTRAINT ${constraintName};`);
    }
    
    // Add new constraint with 'pending_payment' included
    console.log('Adding updated constraint with pending_payment...');
    await db.pool.query(`
      ALTER TABLE users 
      ADD CONSTRAINT users_subscription_status_check 
      CHECK (subscription_status IN ('active', 'trialing', 'past_due', 'canceled', 'incomplete', 'incomplete_expired', 'unpaid', 'pending_payment'));
    `);
    
    console.log('✅ Constraint updated successfully!');
    console.log('\nValid subscription_status values now include:');
    console.log('  - active');
    console.log('  - trialing');
    console.log('  - past_due');
    console.log('  - canceled');
    console.log('  - incomplete');
    console.log('  - incomplete_expired');
    console.log('  - unpaid');
    console.log('  - pending_payment (NEW)');
    
  } catch (error) {
    console.error('Error:', error.message);
  } finally {
    process.exit(0);
  }
}

fixConstraint();

