<?php

namespace App\Livewire;

use App\Models\LibraryTrack;
use App\Services\LibraryService;
use Livewire\Component;
use Livewire\Attributes\Title;
use Livewire\Attributes\Layout;

class TrackDetail extends Component
{
    public $slug;
    public $track;
    public $relatedTracks = [];
    public $isPlaying = false;
    public $currentTime = 0;
    public $duration = 0;
    public $isDemoMode = false;

    public function mount($slug)
    {
        $this->slug = $slug;
        $this->loadTrack();
        $this->loadRelatedTracks();
        
        // Set demo duration for tracks without actual audio files
        if ($this->track && !$this->track->duration) {
            $this->track->duration = 180; // 3 minutes default for demo
        }
    }

    public function loadTrack()
    {
        $this->track = LibraryTrack::where('slug', $this->slug)
            ->active()
            ->with('category')
            ->first();

        if (!$this->track) {
            abort(404);
        }
    }

    public function loadRelatedTracks()
    {
        $this->relatedTracks = LibraryTrack::where('category_id', $this->track->category_id)
            ->where('id', '!=', $this->track->id)
            ->active()
            ->limit(4)
            ->get();
    }

    public function play()
    {
        $this->isPlaying = true;
        $this->dispatch('play-audio', trackId: $this->track->id);
    }

    public function pause()
    {
        $this->isPlaying = false;
        $this->dispatch('pause-audio');
    }

    public function updateProgress($currentTime, $duration)
    {
        $this->currentTime = $currentTime;
        $this->duration = $duration;
    }

    public function seekTo($time)
    {
        $this->dispatch('seek-audio', time: $time);
    }

    #[Title('Track Detail - Vybe')]
    public function render()
    {
        return view('livewire.pages.track-detail');
    }
}
