<?php

namespace App\Livewire\Favorites;

use App\Models\Favorite;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;

    public function toggleFavorite(string $trackId): void
    {
        $query = Favorite::query()->where('user_id', auth()->id())->where('track_id', $trackId);
        if ($query->exists()) {
            $query->delete();
            $this->dispatch('toast', type: 'success', message: 'Removed from favorites');
        } else {
            Favorite::create([
                'user_id' => auth()->id(),
                'track_id' => $trackId,
                'created_at' => now(),
            ]);
            $this->dispatch('toast', type: 'success', message: 'Added to favorites');
        }
        $this->resetPage();
    }

    public function render()
    {
        $favorites = Favorite::query()
            ->where('user_id', auth()->id())
            ->with('track')
            ->orderByDesc('created_at')
            ->paginate(12);

        return view('livewire.favorites.index', [
            'favorites' => $favorites,
        ]);
    }
}


