<?php

namespace App\Livewire\Favorites;

use App\Models\Favorite;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;

    public function remove(string $trackId): void
    {
        Favorite::query()->where('user_id', auth()->id())->where('track_id', $trackId)->delete();
        $this->dispatch('toast', type: 'success', message: 'Removed from favorites');
        $this->resetPage();
    }

    public function render()
    {
        $favorites = Favorite::query()
            ->where('user_id', auth()->id())
            ->with('track')
            ->orderByDesc('created_at')
            ->paginate(12);

        return view('livewire.favorites.index', [
            'favorites' => $favorites,
        ]);
    }
}


