<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl font-heading text-neutral-800 leading-tight">
            {{ __('Admin Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <!-- Stats Overview -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <div class="bg-white rounded-2xl shadow-md p-6 border border-neutral-200">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-primary-100 rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-neutral-600">Categories</p>
                            <p class="text-2xl font-bold font-heading text-neutral-900">{{ $stats['categories'] }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-2xl shadow-md p-6 border border-neutral-200">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-accent-100 rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-accent-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19V6l12-3v13M9 19c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zm12-3c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zM9 10l12-3"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-neutral-600">Tracks</p>
                            <p class="text-2xl font-bold font-heading text-neutral-900">{{ $stats['tracks'] }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-2xl shadow-md p-6 border border-neutral-200">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-yellow-100 rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-neutral-600">Pending Requests</p>
                            <p class="text-2xl font-bold font-heading text-neutral-900">{{ $stats['pendingRequests'] }}</p>
                        </div>
                    </div>
                </div>

                <div class="bg-white rounded-2xl shadow-md p-6 border border-neutral-200">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                                <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                                </svg>
                            </div>
                        </div>
                        <div class="ml-4">
                            <p class="text-sm font-medium text-neutral-600">Safety Events</p>
                            <p class="text-2xl font-bold font-heading text-neutral-900">{{ $stats['safetyEvents'] }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
                <!-- Recent Custom Requests -->
                <div class="bg-white rounded-2xl shadow-md border border-neutral-200">
                    <div class="px-6 py-4 border-b border-neutral-200">
                        <h3 class="text-lg font-semibold font-heading text-neutral-900">Recent Custom Requests</h3>
                    </div>
                    <div class="p-6">
                        @if($recentRequests->count() > 0)
                            <div class="space-y-4">
                                @foreach($recentRequests as $request)
                                    <div class="flex items-center justify-between p-4 bg-neutral-50 rounded-xl">
                                        <div class="flex-1">
                                            <h4 class="font-medium text-neutral-900">{{ $request->topic }}</h4>
                                            <p class="text-sm text-neutral-600">{{ $request->user->name }}</p>
                                            <p class="text-xs text-neutral-500">{{ $request->created_at->diffForHumans() }}</p>
                                        </div>
                                        <div class="flex space-x-2">
                                            <a href="{{ route('admin.custom-requests') }}" 
                                               class="inline-flex items-center px-3 py-1 border border-transparent text-xs font-medium rounded-full text-primary-700 bg-primary-100 hover:bg-primary-200 transition-colors">
                                                Review
                                            </a>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="mt-4">
                                <a href="{{ route('admin.custom-requests') }}" 
                                   class="text-primary-600 hover:text-primary-700 text-sm font-medium">
                                    View All Requests →
                                </a>
                            </div>
                        @else
                            <p class="text-neutral-500 text-center py-4">No pending requests</p>
                        @endif
                    </div>
                </div>

                <!-- Recent Safety Events -->
                <div class="bg-white rounded-2xl shadow-md border border-neutral-200">
                    <div class="px-6 py-4 border-b border-neutral-200">
                        <h3 class="text-lg font-semibold font-heading text-neutral-900">Recent Safety Events</h3>
                    </div>
                    <div class="p-6">
                        @if($recentSafetyEvents->count() > 0)
                            <div class="space-y-4">
                                @foreach($recentSafetyEvents as $event)
                                    <div class="flex items-center justify-between p-4 bg-neutral-50 rounded-xl">
                                        <div class="flex-1">
                                            <h4 class="font-medium text-neutral-900">{{ $event->event_type }}</h4>
                                            <p class="text-sm text-neutral-600">{{ $event->user?->name ?? 'Anonymous' }}</p>
                                            <p class="text-xs text-neutral-500">{{ $event->created_at->diffForHumans() }}</p>
                                        </div>
                                        <div class="flex space-x-2">
                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium 
                                                @if($event->severity === 'low') bg-green-100 text-green-800
                                                @elseif($event->severity === 'medium') bg-yellow-100 text-yellow-800
                                                @else bg-red-100 text-red-800 @endif">
                                                {{ ucfirst($event->severity) }}
                                            </span>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="mt-4">
                                <a href="{{ route('admin.safety-events') }}" 
                                   class="text-primary-600 hover:text-primary-700 text-sm font-medium">
                                    View All Events →
                                </a>
                            </div>
                        @else
                            <p class="text-neutral-500 text-center py-4">No open safety events</p>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Navigation Cards -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <a href="{{ route('admin.categories') }}" 
                   class="group block bg-white rounded-2xl shadow-md border border-neutral-200 hover:shadow-lg transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01]">
                    <div class="p-6 text-center">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-primary-100 mb-4 group-hover:bg-primary-200 transition-colors">
                            <svg class="h-8 w-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold font-heading text-neutral-900 mb-2 group-hover:text-primary-600 transition-colors">
                            Manage Categories
                        </h3>
                        <p class="text-neutral-600 text-sm">Organize and manage wellness content categories</p>
                    </div>
                </a>

                <a href="{{ route('admin.tracks') }}" 
                   class="group block bg-white rounded-2xl shadow-md border border-neutral-200 hover:shadow-lg transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01]">
                    <div class="p-6 text-center">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-accent-100 mb-4 group-hover:bg-accent-200 transition-colors">
                            <svg class="h-8 w-8 text-accent-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19V6l12-3v13M9 19c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zm12-3c0 1.105-1.343 2-3 2s-3-.895-3-2 1.343-2 3-2 3 .895 3 2zM9 10l12-3"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold font-heading text-neutral-900 mb-2 group-hover:text-accent-600 transition-colors">
                            Manage Tracks
                        </h3>
                        <p class="text-neutral-600 text-sm">Upload and manage wellness audio tracks</p>
                    </div>
                </a>

                <a href="{{ route('admin.safety-events') }}" 
                   class="group block bg-white rounded-2xl shadow-md border border-neutral-200 hover:shadow-lg transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01]">
                    <div class="p-6 text-center">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-red-100 mb-4 group-hover:bg-red-200 transition-colors">
                            <svg class="h-8 w-8 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold font-heading text-neutral-900 mb-2 group-hover:text-red-600 transition-colors">
                            Safety Events
                        </h3>
                        <p class="text-neutral-600 text-sm">Monitor and resolve safety concerns</p>
                    </div>
                </a>
            </div>
        </div>
    </div>
</x-app-layout>
