<?php

namespace App\Livewire\Account;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;

class Dashboard extends Component
{
    public function render()
    {
        $user = Auth::user();
        $recentOrders = $user->orders()->latest()->take(5)->get();
        $orderCount = $user->orders()->count();

        return view('livewire.account.dashboard', [
            'recentOrders' => $recentOrders,
            'orderCount' => $orderCount,
        ])->layout('layouts.shop');
    }
}




