<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OrderLine extends Model
{
    use HasFactory;

    protected $fillable = [
        'orders_id',
        'colourways_id',
        'item_name',
        'item_description',
        'colourway_name',
        'item_sku',
        'quantity',
        'initial_unit_price',
        'initial_line_total',
        'invoiced_unit_price',
        'invoiced_line_total',
    ];

    protected function casts(): array
    {
        return [
            'quantity' => 'integer',
            'initial_unit_price' => 'decimal:2',
            'initial_line_total' => 'decimal:2',
            'invoiced_unit_price' => 'decimal:2',
            'invoiced_line_total' => 'decimal:2',
        ];
    }

    /**
     * Get the order that owns the order line
     */
    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class, 'orders_id');
    }

    /**
     * Get the colourway for the order line
     */
    public function colourway(): BelongsTo
    {
        return $this->belongsTo(Colourway::class, 'colourways_id');
    }
}

