<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ReceiptLine extends Model
{
    protected $fillable = [
        'receipt_id',
        'description',
        'quantity',
        'unit_price',
        'line_total',
        'vat_rate',
        'vat_amount',
        'department_id',
        'account_id',
        'is_personal',
        'meta',
    ];

    protected $casts = [
        'is_personal' => 'boolean',
        'meta' => 'array',
    ];

    public function receipt(): BelongsTo
    {
        return $this->belongsTo(Receipt::class);
    }

    public function department(): BelongsTo
    {
        return $this->belongsTo(Department::class);
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(Account::class);
    }

    public function vatAnalysis(): HasOne
    {
        return $this->hasOne(VatAnalysis::class);
    }
}
