<?php

namespace App\Livewire\Admin;

use App\Models\Category;
use Livewire\Component;
use Livewire\WithPagination;

class Categories extends Component
{
    use WithPagination;

    public $search = '';
    public $statusFilter = '';
    public $perPage = 10;

    protected $queryString = [
        'search' => ['except' => ''],
        'statusFilter' => ['except' => ''],
        'perPage' => ['except' => 10],
    ];

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingStatusFilter()
    {
        $this->resetPage();
    }

    public function viewCategory($categoryId)
    {
        return redirect()->route('admin.categories.show', $categoryId);
    }

    public function deleteCategory($categoryId)
    {
        $category = Category::findOrFail($categoryId);
        
        // Check if category has items
        $itemsCount = $category->items()->count();
        
        if ($itemsCount > 0) {
            session()->flash('error', "Cannot delete category '{$category->name}' because it has {$itemsCount} items associated with it.");
            return;
        }
        
        $categoryName = $category->name;
        $category->delete();
        
        session()->flash('message', "Category '{$categoryName}' has been deleted successfully!");
    }

    public function render()
    {
        $query = Category::query();

        if ($this->search) {
            $query->where(function ($q) {
                $q->where('name', 'like', '%' . $this->search . '%')
                  ->orWhere('description', 'like', '%' . $this->search . '%');
            });
        }

        if ($this->statusFilter) {
            if ($this->statusFilter === 'active') {
                $query->where('is_active', true);
            } elseif ($this->statusFilter === 'inactive') {
                $query->where('is_active', false);
            }
        }

        $categories = $query->orderBy('sort_order')
                           ->orderBy('name')
                           ->paginate($this->perPage);

        return view('livewire.admin.categories', [
            'categories' => $categories
        ])
            ->layout('layouts.admin')
            ->title('Categories');
    }
}
