const db = require('./src/db-multi-tenant');

async function checkColumns() {
  try {
    console.log('Checking subscription_tiers table columns...\n');
    
    const result = await db.pool.query(`
      SELECT column_name, data_type
      FROM information_schema.columns
      WHERE table_name = 'subscription_tiers'
      ORDER BY ordinal_position;
    `);
    
    console.log('All columns in subscription_tiers table:');
    result.rows.forEach(col => {
      console.log(`  - ${col.column_name} (${col.data_type})`);
    });
    
    // Check if the columns we need exist
    const stripePriceId = result.rows.find(col => col.column_name === 'stripe_price_id');
    const stripeProductId = result.rows.find(col => col.column_name === 'stripe_product_id');
    
    console.log('\n');
    if (stripePriceId) {
      console.log('✅ stripe_price_id column exists');
    } else {
      console.log('❌ stripe_price_id column NOT FOUND');
    }
    
    if (stripeProductId) {
      console.log('✅ stripe_product_id column exists');
    } else {
      console.log('❌ stripe_product_id column NOT FOUND');
    }
    
    await db.pool.end();
    process.exit(0);
  } catch (error) {
    console.error('Error:', error.message);
    process.exit(1);
  }
}

checkColumns();

