<div>
    @if(count($colourways) > 0)
        <div class="mb-4">
            <label class="form-label fw-semibold">Select Colourway</label>
            <select wire:model="colourwayId" class="form-select form-select-lg">
                @foreach($colourways as $colourway)
                    <option value="{{ $colourway->id }}">{{ $colourway->reference }}</option>
                @endforeach
            </select>
        </div>
    @endif

    <div class="mb-4">
        <label class="form-label fw-semibold">Quantity</label>
        <div class="input-group input-group-lg" style="max-width: 180px;">
            <button class="btn btn-outline-secondary" type="button" 
                    wire:click="$set('quantity', {{ max(1, $quantity - 1) }})">
                -
            </button>
            <input type="number" wire:model="quantity" class="form-control text-center" min="1">
            <button class="btn btn-outline-secondary" type="button"
                    wire:click="$set('quantity', {{ $quantity + 1 }})">
                +
            </button>
        </div>
    </div>

    <div class="d-grid gap-2">
        <button wire:click="addToBasket" class="btn btn-ys-primary btn-lg" @if($added) disabled @endif>
            @if($added)
                <span>✓ Added to Basket</span>
            @else
                <span>Add to Basket</span>
            @endif
        </button>
        @if($added)
            <a href="{{ route('basket') }}" class="btn btn-ys-secondary btn-lg">
                View Basket
            </a>
        @endif
    </div>

    @if($added)
        <script>
            setTimeout(() => {
                @this.set('added', false);
            }, 3000);
        </script>
    @endif
</div>
