<?php
$meta = [
  'title' => 'Google Workspace Migration & Training | Case Study',
  'description' => 'Managed migration to Google Workspace and trained staff for collaboration at scale.',
  'canonical' => 'https://neilwiddowson.co.uk/portfolio/google-workspace-migration.php'
];
$currentPage = 'portfolio';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-4xl">
    <h1 class="text-3xl font-bold tracking-tight">Google Workspace Migration & Training</h1>
    <p class="mt-2 text-sm text-gray-600">Planning, vendor liaison, rollout and support</p>

    <div class="mt-6 grid gap-6 md:grid-cols-2">
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">What I did</h2>
        <ul class="mt-2 list-disc list-inside text-sm text-gray-700 space-y-2">
          <li>Stakeholder management and migration planning.</li>
          <li>Account provisioning, security, and data transfer.</li>
          <li>Documentation and 1‑to‑1/team training sessions.</li>
        </ul>
      </div>
      <div class="card p-4">
        <h2 class="font-semibold text-gray-900">Outcome</h2>
        <p class="mt-2 text-sm text-gray-700">Simpler collaboration with shared drives, Meet, and Gmail; reduced IT friction for a 30+ person business.</p>
      </div>
    </div>

    <div class="mt-6">
      <a href="/portfolio/" class="btn-secondary">Back to portfolio</a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>


