<?php

namespace App\Jobs;

use App\Services\EMLProcessingService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessEMLReceipt implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $timeout = 60;
    public int $maxExceptions = 2;

    public function __construct(public string $emlPath) {}

    public function handle(EMLProcessingService $emlService): void
    {
        $receiptData = $emlService->processEMLFile($this->emlPath);
        
        if ($receiptData) {
            $receipt = $emlService->createReceiptFromEML($this->emlPath, $receiptData);
            \Log::info('EML receipt processed successfully', [
                'receipt_id' => $receipt->id,
                'eml_path' => $this->emlPath
            ]);
        }
    }
}
