<?php
$meta = [
  'title' => 'Bitdefender for Home | North East',
  'description' => 'Bitdefender home security for families in Newcastle and the North East. Setup, licenses, and ongoing management.',
  'canonical' => 'https://neilwiddowson.co.uk/bitdefender/home.php'
];
$currentPage = '';
include __DIR__.'/../includes/header.php';
?>

<main id="main-content" class="section">
  <div class="container max-w-3xl">
    <div class="flex items-center gap-4">
      <img src="https://www.bitdefender.com/pages/consumer/en/new/media_160ec11465e84e336f2cf043d5d8ecbc0e82fdcba.png?width=750&format=png&optimize=medium" width="140" height="32" alt="Bitdefender" class="h-8 w-auto" loading="lazy">
      <h1 class="text-3xl font-bold tracking-tight">Bitdefender for Home</h1>
    </div>
    <p class="mt-3 text-gray-700">Protect your family's devices with comprehensive home security. I supply licenses, configure protection, and manage alerts — so you don't have to.</p>
    <ul class="mt-6 space-y-2 list-disc list-inside text-gray-800">
      <li>Setup and onboarding — fast, remote</li>
      <li>Family protection across all devices</li>
      <li>Parental controls and safe browsing</li>
      <li>Friendly ongoing support</li>
    </ul>
    <div class="mt-6 flex gap-3">
      <a class="btn-primary" href="/contact/">Get a quote</a>
      <a class="btn-secondary" href="/services/it-support.php">See IT Support</a>
    </div>
  </div>
</main>

<?php include __DIR__.'/../includes/footer.php'; ?>
