<!DOCTYPE html>
<html>
<head>
    <title>Product Test</title>
    <style>
        body { font-family: sans-serif; padding: 20px; }
        .product { border: 1px solid #ccc; padding: 10px; margin: 10px 0; }
    </style>
</head>
<body>
    <h1>Direct Product Test</h1>
    
    @php
        $products = \App\Models\Item::with(['season', 'category'])->get();
    @endphp
    
    <p><strong>Total products in database:</strong> {{ $products->count() }}</p>
    
    @if($products->count() > 0)
        @foreach($products as $product)
            <div class="product">
                <h3>{{ $product->name }}</h3>
                <p>ID: {{ $product->id }}</p>
                <p>Slug: {{ $product->slug }}</p>
                <p>Price: £{{ $product->price }}</p>
                <p>Season: {{ $product->season ? $product->season->name : 'NONE' }}</p>
                <p>Category: {{ $product->category ? $product->category->name : 'NONE' }}</p>
            </div>
        @endforeach
    @else
        <p style="color: red;">NO PRODUCTS FOUND</p>
    @endif
</body>
</html>



