<?php

namespace Database\Seeders;

use App\Models\Item;
use App\Models\Season;
use App\Models\Category;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ItemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get seasons and categories
        $seasons = Season::all();
        $categories = Category::all();

        if ($seasons->isEmpty() || $categories->isEmpty()) {
            $this->command->warn('No seasons or categories found. Please run SeasonSeeder and CategorySeeder first.');
            return;
        }

        $items = [
            [
                'name' => 'Classic White T-Shirt',
                'slug' => 'classic-white-t-shirt',
                'description' => 'A timeless classic white t-shirt made from 100% organic cotton. Perfect for everyday wear.',
                'short_description' => 'Classic white cotton t-shirt',
                'price' => 24.99,
                'sku' => 'TSH-WHT-001',
                'is_active' => true,
                'images' => ['https://via.placeholder.com/400x400/ffffff/000000?text=White+T-Shirt'],
                'specifications' => [
                    'material' => '100% Organic Cotton',
                    'fit' => 'Regular',
                    'care' => 'Machine wash cold'
                ],
                'no_columns' => 3,
            ],
            [
                'name' => 'Denim Blue Jeans',
                'slug' => 'denim-blue-jeans',
                'description' => 'Classic blue denim jeans with a comfortable fit. Perfect for casual and semi-formal occasions.',
                'short_description' => 'Classic blue denim jeans',
                'price' => 89.99,
                'sku' => 'JNS-BLU-001',
                'is_active' => true,
                'images' => ['https://via.placeholder.com/400x400/0066cc/ffffff?text=Blue+Jeans'],
                'specifications' => [
                    'material' => '98% Cotton, 2% Elastane',
                    'fit' => 'Slim',
                    'care' => 'Machine wash cold'
                ],
                'no_columns' => 3,
            ],
            [
                'name' => 'Summer Floral Dress',
                'slug' => 'summer-floral-dress',
                'description' => 'Light and airy floral dress perfect for summer days. Features a comfortable fit and beautiful print.',
                'short_description' => 'Light summer floral dress',
                'price' => 65.99,
                'sku' => 'DRS-FLR-001',
                'is_active' => true,
                'images' => ['https://via.placeholder.com/400x400/ff69b4/ffffff?text=Floral+Dress'],
                'specifications' => [
                    'material' => '100% Polyester',
                    'fit' => 'A-line',
                    'care' => 'Machine wash cold'
                ],
                'no_columns' => 3,
            ],
            [
                'name' => 'Leather Jacket',
                'slug' => 'leather-jacket',
                'description' => 'Premium leather jacket with a classic design. Perfect for adding style to any outfit.',
                'short_description' => 'Premium leather jacket',
                'price' => 199.99,
                'sku' => 'JCK-LTH-001',
                'is_active' => true,
                'images' => ['https://via.placeholder.com/400x400/8b4513/ffffff?text=Leather+Jacket'],
                'specifications' => [
                    'material' => '100% Genuine Leather',
                    'fit' => 'Regular',
                    'care' => 'Professional cleaning only'
                ],
                'no_columns' => 3,
            ],
            [
                'name' => 'Canvas Tote Bag',
                'slug' => 'canvas-tote-bag',
                'description' => 'Spacious canvas tote bag perfect for everyday use. Features sturdy handles and multiple compartments.',
                'short_description' => 'Spacious canvas tote bag',
                'price' => 35.99,
                'sku' => 'BAG-CNV-001',
                'is_active' => true,
                'images' => ['https://via.placeholder.com/400x400/daa520/ffffff?text=Tote+Bag'],
                'specifications' => [
                    'material' => '100% Canvas',
                    'size' => 'Large',
                    'care' => 'Spot clean only'
                ],
                'no_columns' => 3,
            ],
            [
                'name' => 'Running Sneakers',
                'slug' => 'running-sneakers',
                'description' => 'Comfortable running sneakers with excellent cushioning and breathable material.',
                'short_description' => 'Comfortable running sneakers',
                'price' => 129.99,
                'sku' => 'SNK-RUN-001',
                'is_active' => true,
                'images' => ['https://via.placeholder.com/400x400/000000/ffffff?text=Running+Shoes'],
                'specifications' => [
                    'material' => 'Mesh upper, rubber sole',
                    'size' => 'Various',
                    'care' => 'Machine wash cold'
                ],
                'no_columns' => 3,
            ],
            [
                'name' => 'Yoga Leggings',
                'slug' => 'yoga-leggings',
                'description' => 'High-waisted yoga leggings with excellent stretch and moisture-wicking properties.',
                'short_description' => 'High-waisted yoga leggings',
                'price' => 45.99,
                'sku' => 'LEG-YGA-001',
                'is_active' => true,
                'images' => ['https://via.placeholder.com/400x400/800080/ffffff?text=Yoga+Leggings'],
                'specifications' => [
                    'material' => '88% Polyester, 12% Spandex',
                    'fit' => 'High-waisted',
                    'care' => 'Machine wash cold'
                ],
                'no_columns' => 3,
            ],
            [
                'name' => 'Silk Scarf',
                'slug' => 'silk-scarf',
                'description' => 'Luxurious silk scarf with a beautiful pattern. Perfect for adding elegance to any outfit.',
                'short_description' => 'Luxurious silk scarf',
                'price' => 79.99,
                'sku' => 'SCF-SLK-001',
                'is_active' => true,
                'images' => ['https://via.placeholder.com/400x400/ff1493/ffffff?text=Silk+Scarf'],
                'specifications' => [
                    'material' => '100% Silk',
                    'size' => '90cm x 90cm',
                    'care' => 'Dry clean only'
                ],
                'no_columns' => 3,
            ],
            [
                'name' => 'Bikini Set',
                'slug' => 'bikini-set',
                'description' => 'Stylish bikini set perfect for beach days. Features a comfortable fit and trendy design.',
                'short_description' => 'Stylish bikini set',
                'price' => 55.99,
                'sku' => 'BKN-SET-001',
                'is_active' => true,
                'images' => ['https://via.placeholder.com/400x400/00bfff/ffffff?text=Bikini+Set'],
                'specifications' => [
                    'material' => '80% Nylon, 20% Spandex',
                    'fit' => 'Regular',
                    'care' => 'Hand wash cold'
                ],
                'no_columns' => 3,
            ],
            [
                'name' => 'Vintage Band T-Shirt',
                'slug' => 'vintage-band-t-shirt',
                'description' => 'Retro-style band t-shirt with a vintage design. Made from soft cotton blend.',
                'short_description' => 'Retro band t-shirt',
                'price' => 32.99,
                'sku' => 'TSH-VNT-001',
                'is_active' => false,
                'images' => ['https://via.placeholder.com/400x400/ff4500/ffffff?text=Vintage+T-Shirt'],
                'specifications' => [
                    'material' => '60% Cotton, 40% Polyester',
                    'fit' => 'Oversized',
                    'care' => 'Machine wash cold'
                ],
                'no_columns' => 3,
            ],
        ];

        foreach ($items as $itemData) {
            // Randomly assign season and category
            $season = $seasons->random();
            $category = $categories->random();
            
            Item::updateOrCreate(
                ['slug' => $itemData['slug']],
                array_merge($itemData, [
                    'seasons_id' => $season->id,
                    'categories_id' => $category->id,
                ])
            );
        }
    }
}
