const db = require('./src/db-multi-tenant');

async function checkSuperusers() {
  try {
    const result = await db.pool.query(`
      SELECT id, username, email, is_superuser, created_at
      FROM users
      WHERE is_superuser = true
      ORDER BY created_at DESC
    `);
    
    console.log('Superuser accounts:\n');
    
    if (result.rows.length === 0) {
      console.log('❌ No superuser accounts found!');
      console.log('\nYou need to create one. Run: node setup-superuser-auto.js');
    } else {
      result.rows.forEach((user, index) => {
        console.log(`${index + 1}. Username: ${user.username}`);
        console.log(`   Email: ${user.email}`);
        console.log(`   ID: ${user.id}`);
        console.log(`   Created: ${user.created_at}`);
        console.log('');
      });
      
      console.log('To log in, use the email and the password you set when creating the superuser.');
      console.log('If you forgot the password, you can reset it by running setup-superuser-auto.js again.');
    }
    
  } catch (error) {
    console.error('Error:', error.message);
  } finally {
    process.exit(0);
  }
}

checkSuperusers();

