# NRW Web - Modern Photo Gallery SaaS Platform

A beautiful, fast, and scalable photo gallery platform for photographers. Built on Google Cloud Run with multi-tenant architecture.

## 🚀 Features

- **Beautiful Galleries** - Modern, responsive design with justified grid layout
- **Multi-Tenant SaaS** - Unlimited photographers on one platform
- **Custom Domains** - Each photographer can use their own domain
- **Usage Limits** - Automatic tier-based limits (Starter, Professional, Business)
- **Cloud Storage** - Scalable storage with Google Cloud Storage
- **Fast CDN** - Global delivery via Cloudflare
- **Admin Panel** - Full-featured gallery management
- **Private Albums** - Secure access with unique codes
- **Age Verification** - Optional 18+ gate
- **White-Label Ready** - Fully customizable branding per customer

## 💰 Perfect for SaaS

- **Low infrastructure costs** (80-90% profit margins)
- **Scalable** from 1 to 1,000+ customers
- **Automated billing** with Stripe
- **Self-service signup** 
- **Usage limits enforced** automatically
- **Multi-tenant** architecture

## 📊 Pricing Tiers (Suggested)

| Tier | Price | Storage | Photos | Your Cost | Profit |
|------|-------|---------|--------|-----------|--------|
| Starter | £10/mo | 10 GB | 1,000 | £2/mo | 80% |
| Professional | £25/mo | 100 GB | 10,000 | £11/mo | 56% |
| Business | £75/mo | 300 GB | 30,000 | £41/mo | 45% |

See [PRICING-STRATEGY.md](./PRICING-STRATEGY.md) for complete business model.

## 🛠️ Tech Stack

- **Backend:** Node.js, Express
- **Database:** PostgreSQL (Cloud SQL for production)
- **Storage:** Google Cloud Storage
- **Hosting:** Google Cloud Run (serverless)
- **CDN:** Cloudflare (free tier)
- **Frontend:** Server-rendered EJS templates
- **Payments:** Stripe (ready to integrate)

## 🏃 Quick Start

### Local Development

```bash
# Install dependencies
npm install

# Create .env file
cp .env.example .env

# Edit .env with your settings
# USE_JSON=false (SQLite for local dev)
# ADMIN_PASSWORD=changeme

# Build CSS
npm run build:css

# Start server
npm start
```

Visit `http://localhost:3000`

### Deploy to Google Cloud Run

```bash
# Set your project
gcloud config set project YOUR-PROJECT-ID

# Create storage bucket
gcloud storage buckets create gs://YOUR-BUCKET-NAME --location=europe-west1

# Deploy
gcloud run deploy nrw-web \
  --source . \
  --region=europe-west1 \
  --allow-unauthenticated \
  --set-env-vars="USE_JSON=true,USE_CLOUD_STORAGE=true,GCS_BUCKET_NAME=YOUR-BUCKET-NAME,SUBSCRIPTION_TIER=starter" \
  --set-secrets="ADMIN_PASSWORD=ADMIN_PASSWORD:latest"
```

See [DEPLOYMENT.md](./DEPLOYMENT.md) for detailed deployment instructions.

## 🌐 Multi-Tenant Setup

### Subdomain Access (Built-in)

Each photographer gets:
```
john-smith.nrwweb.com
jane-doe.nrwweb.com
```

Configure wildcard DNS: `*.nrwweb.com` → Your Cloud Run service

### Custom Domains (via Cloudflare)

Photographers can use their own domains:
```
johnsmithphotography.com → john-smith.nrwweb.com (CNAME)
```

See [USAGE-LIMITS-GUIDE.md](./USAGE-LIMITS-GUIDE.md) for setup instructions.

## 💳 Adding Stripe (Payment Processing)

Ready for Stripe integration - add webhook endpoint:

```javascript
app.post('/webhook/stripe', async (req, res) => {
  const { customer, subscription } = req.body;
  
  await db.createUser({
    email: customer.email,
    tier: subscription.items[0].price.product,
    stripeCustomerId: customer.id
  });
  
  res.json({ received: true });
});
```

## 📚 Documentation

- [Deployment Guide](./DEPLOYMENT.md) - Deploy to Google Cloud Run
- [Usage Limits Guide](./USAGE-LIMITS-GUIDE.md) - Tier limits and cost control
- [Pricing Strategy](./PRICING-STRATEGY.md) - Business model and marketing

## 🎯 Cost Structure

**Per customer costs (typical usage):**
- Starter: £2/month (80% margin)
- Professional: £11/month (56% margin)
- Business: £41/month (45% margin)

**Infrastructure scales with usage** - only pay for what customers use.

## 🔐 Security

- HTTP Basic Auth for admin panel
- HTTPS everywhere (via Cloud Run)
- DDoS protection (via Cloudflare)
- Rate limiting built-in
- User data isolation

## 🌟 What Makes This Different

- **Sold as a product** - Not a template, a complete business
- **Profitable from day 1** - High margins, low costs
- **Beautiful UI** - Modern design photographers love
- **Scalable** - Handles 1 or 1,000 customers
- **Simple** - No complex setup, just works

## 📈 Growth Path

**Month 1-3:** Get first 10 customers (£100-150/month revenue)  
**Month 4-6:** Grow to 30 customers (£500/month revenue)  
**Month 7-12:** Scale to 100 customers (£1,500-2,000/month revenue)

See [PRICING-STRATEGY.md](./PRICING-STRATEGY.md) for detailed marketing plan.

## 🤝 Support

This is a complete, sellable product. Use it to:
- Run your own photo gallery SaaS
- White-label for agencies
- Offer as part of photography packages

## 📝 License

MIT License - Use commercially, modify, resell.

---

Built with ❤️ for entrepreneurs who want to build profitable SaaS businesses.
