<div class="space-y-6">
    <div class="flex justify-between items-center">
        <h2 class="text-xl font-semibold">Recent check-ins</h2>
        <button class="btn btn-primary" wire:click="$set('showModal', true)">Add check-in</button>
    </div>

    <div class="space-y-3">
        @foreach ($checkins as $c)
            <div class="rounded border p-4">
                <div class="text-sm text-gray-500">{{ $c->created_at->diffForHumans() }}</div>
                <div>{{ $c->note }}</div>
            </div>
        @endforeach
    </div>

    {{ $checkins->links() }}

    <x-modal wire:model="showModal">
        <div class="p-4 space-y-4">
            <h3 class="text-lg font-semibold">Add check-in</h3>
            <textarea class="textarea textarea-bordered w-full" rows="6" wire:model.defer="note"></textarea>
            <div class="flex justify-end gap-2">
                <button class="btn" wire:click="$set('showModal', false)">Cancel</button>
                <button class="btn btn-primary" wire:click="addCheckin">Save</button>
            </div>
            <div wire:show="false" x-data="{ show: false }" x-on:crisis.window="show = true">
                <div x-show="show" class="mt-4 p-4 rounded bg-red-50 border border-red-200 text-sm text-red-800">
                    If you’re in crisis in the UK, call 999 or visit your nearest A&E. You can also contact Samaritans at 116 123.
                </div>
            </div>
        </div>
    </x-modal>
</div>


