@section('title', 'Contact Us - Yarn Store')
@section('meta_description', 'Get in touch with Yarn Store. We\'re here to help with your yarn questions and orders.')

<div class="py-5 text-center" style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-light) 100%); color: white;">
    <div class="container">
        <h1 class="display-4 fw-bold mb-3">Contact Us</h1>
        <p class="lead">We'd love to hear from you</p>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mb-4">
            <div class="ys-card p-4">
                <h3 class="fw-bold mb-4">Send us a message</h3>
                
                @if(session('message'))
                    <div class="alert alert-success alert-dismissible fade show">
                        {{ session('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <form wire:submit.prevent="submit">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-semibold">Name *</label>
                            <input type="text" wire:model="name" class="form-control @error('name') is-invalid @enderror">
                            @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-semibold">Email *</label>
                            <input type="email" wire:model="email" class="form-control @error('email') is-invalid @enderror">
                            @error('email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-semibold">Phone</label>
                            <input type="tel" wire:model="phone" class="form-control">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label class="form-label fw-semibold">Subject *</label>
                            <input type="text" wire:model="subject" class="form-control @error('subject') is-invalid @enderror">
                            @error('subject') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>

                    <div class="mb-4">
                        <label class="form-label fw-semibold">Message *</label>
                        <textarea wire:model="message" rows="5" class="form-control @error('message') is-invalid @enderror"></textarea>
                        @error('message') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>

                    <button type="submit" class="btn btn-ys-primary btn-lg">
                        Send Message
                    </button>
                </form>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Contact Information -->
            <div class="ys-card p-4 mb-4">
                <h4 class="fw-bold mb-3">Get In Touch</h4>
                
                <div class="mb-3">
                    <div class="d-flex align-items-start">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2 mt-1" style="color: var(--ys-primary); flex-shrink: 0;">
                            <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                        </svg>
                        <div>
                            <p class="fw-semibold mb-0">Phone</p>
                            <p class="text-muted small mb-0">01234 567890</p>
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <div class="d-flex align-items-start">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2 mt-1" style="color: var(--ys-primary); flex-shrink: 0;">
                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                            <polyline points="22,6 12,13 2,6"></polyline>
                        </svg>
                        <div>
                            <p class="fw-semibold mb-0">Email</p>
                            <p class="text-muted small mb-0">info@yarnstore.co.uk</p>
                        </div>
                    </div>
                </div>

                <div>
                    <div class="d-flex align-items-start">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2 mt-1" style="color: var(--ys-primary); flex-shrink: 0;">
                            <circle cx="12" cy="12" r="10"></circle>
                            <polyline points="12 6 12 12 16 14"></polyline>
                        </svg>
                        <div>
                            <p class="fw-semibold mb-0">Business Hours</p>
                            <p class="text-muted small mb-0">
                                Monday - Friday: 9am - 5pm<br>
                                Saturday: 10am - 4pm<br>
                                Sunday: Closed
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- FAQ Link -->
            <div class="ys-card p-4">
                <h5 class="fw-bold mb-2">Need Quick Answers?</h5>
                <p class="small text-muted mb-3">Check out our frequently asked questions for instant help</p>
                <a href="{{ route('faq') }}" class="btn btn-outline-primary w-100">
                    View FAQs
                </a>
            </div>
        </div>
    </div>
</div>

