<?php

namespace App\Livewire\Checkins;

use App\Contracts\SafetyService;
use App\Models\UserCheckin;
use Livewire\Component;
use Livewire\WithPagination;

class Index extends Component
{
    use WithPagination;

    public bool $showModal = false;
    public string $note = '';

    public function addCheckin(SafetyService $safety): void
    {
        $this->validate(['note' => ['required', 'string', 'max:2000']]);

        $user = auth()->user();
        $result = $safety->evaluateText($this->note);

        if ($result['action'] === 'route_resources') {
            $this->dispatch('crisis');
            return;
        }

        $textToPersist = $this->note;
        if ($result['action'] === 'redact') {
            $textToPersist = $safety->redact($textToPersist);
        }

        UserCheckin::create([
            'id' => (string) \Illuminate\Support\Str::uuid(),
            'user_id' => $user->id,
            'note' => $textToPersist,
            'created_at' => now(),
        ]);

        $safety->checkAndLog('checkin', $this->note, $user);

        $this->reset(['note', 'showModal']);
        $this->dispatch('toast', type: 'success', message: 'Check-in added');
        $this->resetPage();
    }

    public function render()
    {
        $checkins = UserCheckin::where('user_id', auth()->id())
            ->orderByDesc('created_at')
            ->paginate(10);

        return view('livewire.checkins.index', [
            'checkins' => $checkins,
        ]);
    }
}


