<?php

namespace App\Services\Matching;

use App\Models\ClassificationRule;
use App\Models\Receipt;
use App\Models\ReceiptLine;

class ClassificationService
{
    public function classifyReceipt(Receipt $receipt): void
    {
        // Simple rules-based baseline using stored patterns
        if ($receipt->merchant_name) {
            $rule = ClassificationRule::where('scope', 'merchant')
                ->where('pattern', 'ILIKE', '%'.addcslashes($receipt->merchant_name, '%_').'%')
                ->orderByDesc('weight')
                ->first();
            if ($rule) {
                $receipt->department_id = $rule->department_id ?? $receipt->department_id;
                $receipt->account_id = $rule->account_id ?? $receipt->account_id;
                $receipt->is_personal = $rule->is_personal || $receipt->is_personal;
                $receipt->save();
            }
        }
    }

    public function classifyReceiptLine(ReceiptLine $line): void
    {
        $rule = ClassificationRule::where('scope', 'line_description')
            ->where('pattern', 'ILIKE', '%'.addcslashes($line->description, '%_').'%')
            ->orderByDesc('weight')
            ->first();
        if ($rule) {
            $line->department_id = $rule->department_id ?? $line->department_id;
            $line->account_id = $rule->account_id ?? $line->account_id;
            $line->is_personal = $rule->is_personal || $line->is_personal;
            $line->save();
        }
    }
}


