<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VoiceActor extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'gender',
        'tonality_tags',
    ];

    protected $casts = [
        'tonality_tags' => 'array',
    ];

    public $timestamps = false;

    public function tracks()
    {
        return $this->hasMany(Track::class);
    }
}


