<?php

namespace App\Jobs;

use App\Models\CustomSession;
use App\Services\CustomSessionService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class GenerateCustomSession implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $timeout = 300; // 5 minutes
    public $tries = 3;

    /**
     * Create a new job instance.
     */
    public function __construct(
        private CustomSession $session
    ) {}

    /**
     * Execute the job.
     */
    public function handle(CustomSessionService $service): void
    {
        $service->generateSession($this->session);
    }

    /**
     * Handle a job failure.
     */
    public function failed(\Throwable $exception): void
    {
        $this->session->update([
            'status' => 'failed',
            'failed_at' => now(),
            'failure_reason' => $exception->getMessage(),
        ]);

        \Log::error('Custom session generation job failed', [
            'session_id' => $this->session->id,
            'error' => $exception->getMessage(),
            'trace' => $exception->getTraceAsString(),
        ]);
    }
}
