@extends('layouts.frontend')

@section('meta_title', 'Shop Collections - Yarn Store')
@section('meta_description', 'Browse our seasonal yarn collections. Find the perfect yarn for your next project from our carefully curated selection.')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <span>Collections</span>
            </nav>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-12 text-center">
            <h1 class="display-4 fw-bold mb-3">Our Collections</h1>
            <p class="lead text-muted">Explore our seasonal yarn collections</p>
        </div>
    </div>

    <div class="row g-4">
        @forelse($seasons as $season)
            <div class="col-lg-4 col-md-6">
                <a href="{{ route('collections.season', $season->slug) }}" class="text-decoration-none">
                    <div class="ys-card h-100 overflow-hidden">
                        @if($season->image)
                            <img src="{{ Storage::url($season->image) }}" 
                                 alt="{{ $season->name }}" 
                                 class="product-image"
                                 loading="lazy">
                        @else
                            <div class="product-image d-flex align-items-center justify-content-center" 
                                 style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-light) 100%);">
                                <h3 class="text-white">{{ $season->name }}</h3>
                            </div>
                        @endif
                        <div class="p-4">
                            <h3 class="h4 fw-bold mb-2">{{ $season->name }}</h3>
                            <p class="text-muted mb-3">{{ Str::limit($season->description, 120) }}</p>
                            <div class="d-flex justify-content-between align-items-center">
                                <span class="text-muted small">{{ $season->items_count }} {{ Str::plural('item', $season->items_count) }}</span>
                                <span class="text-primary fw-semibold">
                                    Explore →
                                </span>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @empty
            <div class="col-12">
                <div class="ys-card p-5 text-center">
                    <p class="text-muted mb-0">No collections available at the moment. Please check back soon!</p>
                </div>
            </div>
        @endforelse
    </div>
</div>
@endsection

