<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Department;

class DepartmentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $departments = [
            ['name' => 'Overheads', 'code' => 'OVH'],
            ['name' => 'Wholesale', 'code' => 'WHO'],
            ['name' => 'Commission', 'code' => 'COM'],
            ['name' => 'Yarn Commission', 'code' => 'YCOM'],
            ['name' => 'Yarn Store', 'code' => 'YST'],
        ];

        foreach ($departments as $dept) {
            Department::firstOrCreate(['name' => $dept['name']], $dept);
        }
    }
}
