<tbody>
    @foreach($drops as $d=>$drop)
    @if(!isset($this->chunk[$d]))
        {{dd($this->chunk, $drops)}}
    @endif
        @if($this->chunk[$d]['is_first_in_shipment'])
            <tr>
                <td colspan="100%" class="py-3">

            </td>
            </tr>
        @endif
        <tr id="{{$drop['id']}}"
            class="
                @if($drop['flag_issue']) bg-issue
                @elseif($drop['customer_order_lines']['cancelled']) bg-red
                @elseif($drop['complete']) shipped
                @elseif(($drop['shipment_status'] ?? $drop['shipment_sample']['status']) == 'approved' || ($drop['shipment_sample']['status'] == "Not Required" && $drop['sealer_sample']['status'] == "Not Required")) bg-good
                @elseif($drop['shipment_sample']['status'] == 'rejected') bg-issue
                @endif

                @if($drop['customer_order_lines']['colourways']['style_versions']['styles']['cancelled'] || $drop['customer_order_lines']['colourways']['cancelled']) ss_cancelled @endif
            "
            style="
                @if($this->chunk[$d]['is_first_in_shipment']) border-top: 3px solid #000 !important; @endif
            "
            >

            <td class="align-middle" style="min-width:100px" rowspan="2">
                <div class="d-flex flex-column align-items-center text-center">
                    <!-- Drop ID -->
                    <div class="fw-bold text-primary mb-3 fs-5">{{$drop['id']}}</div>
                    
                    <!-- Select Checkbox -->
                    <div class="form-check mb-3 d-flex justify-content-center">
                        <input type="checkbox"
                            class="form-check-input"
                            style="transform: scale(1.2);"
                            x-data="{ checked: @entangle('selected.' . $drop['id']) }"
                            x-model="checked"
                            :checked="checked"
                            x-on:change="Livewire.dispatch('updateSelection', { shipmentLineId: {{ $drop['id'] }}, checked })"
                        >
                    </div>

                    <!-- Action Buttons Row -->
                    <div class="d-flex flex-column gap-2 align-items-center">
                        @can('order:update')
                            <button 
                                type="button" 
                                class="btn btn-sm btn-outline-primary"
                                x-data 
                                x-on:click="$dispatch('open-modal', {name:'split-drop'}); Livewire.dispatch('open-split-drop-modal', {dropId: {{ $drop['id'] }}})"
                                title="Split this drop into multiple drops"
                            >
                                <i class="fas fa-cut me-1"></i>Split
                            </button>
                        @endcan

                        <!-- Flag Status -->
                        <div class="cursor-pointer" 
                             x-data="{ flagged: {{ $drop['flag_issue'] ? 'true' : 'false' }} }"
                             x-on:click="flagged = !flagged; $wire.updateFlagIssue({{ $drop['id'] }}, flagged)">
                            <span x-show="flagged" class="badge bg-danger">Flagged</span>
                            <span x-show="!flagged" class="badge bg-light text-dark border">Click to Flag</span>
                        </div>
                    </div>
                </div>
            </td>
            @if($columns['Season'])
                <td class="align-middle" style="min-width: 150px">
                    <span class="fw-bold">{{ $drop['customer_order_lines']['customer_orders']['seasons']['description'] }}</span>
                </td>
            @endif
            @if($columns['Factory'])
                <td class="align-middle" style="min-width: 150px">
                    <div class="fw-semibold">{{ $drop['customer_order_lines']['colourways']['style_versions']['factories']['name'] }}</div>
                </td>
            @endif
            @if($columns['Customer'])
                <td class="align-middle" style="min-width: 150px">
                    <div class="fw-bold text-dark">{{ $drop['customer_order_lines']['customer_orders']['customers']['name'] }}</div>
                </td>
            @endif
            @if($columns['Order No'])
                <td class="align-middle" role="button" x-data x-on:click="$dispatch('open-modal', {name:'edit-order'})" wire:click="$dispatch('edit-order', {order: {{$drop['customer_order_lines']['customer_orders_id']}}})">
                    <div class="fw-bold text-primary">{{ $drop['customer_order_lines']['customer_orders']['customer_po'] }}</div>
                    <small class="text-muted">{{ date("d-M", strtotime($drop['customer_order_lines']['customer_orders']['order_date'])) }}</small>
                </td>
            @endif
            @if($columns['Style'])
                <td class="align-middle" role="button" x-data x-on:click="$dispatch('open-modal', {name:'edit-style'})" wire:click="$dispatch('edit-style', {style: {{$drop['customer_order_lines']['colourways']['style_versions']['styles_id']}}})">
                    <div class="d-flex flex-wrap gap-1 mb-1">
                        <div class="badge bg-primary">{{ $drop['customer_order_lines']['colourways']['style_versions']['styles']['designs_id'] }}</div>
                        <div class="badge bg-secondary">{{ $drop['customer_order_lines']['colourways']['style_versions']['name'] }}</div>
                    </div>
                    @if($drop['customer_order_lines']['colourways']['style_versions']['styles']['customer_ref'])
                        <div class="text-muted small">{{ $drop['customer_order_lines']['colourways']['style_versions']['styles']['customer_ref'] }}</div>
                    @endif
                </td>
            @endif
            @if($columns['Description'])
                <td class="align-middle" style="min-width: 150px">
                    <div class="text-muted">{{ Str::title($drop['customer_order_lines']['colourways']['style_versions']['styles']['designs']['description']) }}</div>
                </td>
            @endif
            @if($columns['Colour'])
                <td class="align-middle">
                    <span class="fw-bold">{{ Str::title($drop['customer_order_lines']['colourways']['name']) }}</span>
                </td>
            @endif
            @if($columns['Image'])
                <td rowspan="2" class="text-center align-middle">
                    @if(!empty($drop['customer_order_lines']['colourways']['img_thumb']))
                        <img style="max-width: 120px; max-height: 120px;" class="img-fluid rounded shadow-sm"
                        src="{{ $drop['customer_order_lines']['colourways']['thumb_url'] }}" loading="lazy">
                    @else
                        <div class="text-muted small">No Image</div>
                    @endif
                </td>
            @endif

            @if($columns['Sizes'])
                <td rowspan="2">
                    @if(!empty($drop['customer_order_lines']['customer_order_line_quantities']))
                        <table class="table table-sm text-center table-borderless mb-0" style="width: unset; margin: auto; font-size: 0.75rem;">
                            <tr style="background: inherit !important">
                                <td class="text-end" style="padding: 3px 6px; font-size: 0.7rem;">Size</td>
                                @foreach($drop['customer_order_lines']['customer_order_line_quantities'] as $size)
                                        <td style="padding: 3px 6px; font-weight: bold; font-size: 0.7rem;">{{ $size['sizes']['name'] }}</td>
                                @endforeach
                                <td style="padding: 3px 6px; font-weight: bold; font-size: 0.7rem;">Total</td>
                            </tr>
                            @if($columns['Sizes - Ordered'])
                                <tr style="background: inherit !important">
                                    <td class="text-end" style="padding: 3px 6px; font-size: 0.7rem;">Ordered</td>
                                    @foreach($drop['shipment_line_sizes'] as $s=>$size)
                                        <td style="padding: 3px 6px;">
                                            @if(Gate::check('order:update'))
                                                <input type="text"
                                                    class="form-control form-control-sm text-center"
                                                    style="width: 40px; padding: 2px 3px; font-size: 0.7rem; height: 22px; background: transparent; border: none; resize: none; outline: none; box-shadow: none;"
                                                    id="qty_{{ $drop['id'] }}_{{ $size['sizes_id'] }}"
                                                    wire:key="qty_{{ $drop['id'] }}_{{ $size['sizes_id'] }}"
                                                    x-data="{ fieldValue: @js($size['qty']) }"
                                                    x-model.debounce.200ms="fieldValue"
                                                    x-on:change.debounce.200ms="Livewire.dispatch('updateQty', { sizeId: {{ $size['id'] }}, value: fieldValue })">
                                            @else
                                                <span style="font-size: 0.7rem;">{{ $size['qty'] }}</span>
                                            @endif
                                        </td>
                                    @endforeach
                                    <td style="padding: 3px 6px; font-weight: bold; font-size: 0.7rem;">{{ $drop['total_pieces'] }}</td>
                                </tr>
                            @endif
                            <tr style="background: inherit !important">
                                <td class="text-end" style="padding: 3px 6px; font-size: 0.7rem;">Shipped</td>
                                @foreach($drop['shipment_line_sizes'] as $s => $size)
                                    <td style="padding: 3px 6px;">
                                        @if(Gate::check('order:update') || Gate::check('finance:update'))
                                            <input type="text"
                                                class="form-control form-control-sm text-center"
                                                style="width: 40px; padding: 2px 3px; font-size: 0.7rem; height: 22px; background: transparent; border: none; resize: none; outline: none; box-shadow: none;"
                                                id="shipped_qty_{{ $drop['id'] }}_{{ $size['id'] }}"
                                                wire:key="qty_{{ $drop['id'] }}_{{ $size['id'] }}"
                                                x-data="shipmentHandler({{ $drop['id'] }}, {{ $size['shipped_qty'] ?? 0 }})"
                                                x-model.debounce.200ms="fieldValue"
                                                x-on:change.debounce.200ms="Livewire.dispatch('updateShippedQty', { sizeId: {{ $size['id'] }}, value: fieldValue })"
                                                x-on:paste.prevent="handlePaste($event, '{{ $drop['id'] }}')">
                                        @else
                                            <span style="font-size: 0.7rem;">{{ $size['shipped_qty'] }}</span>
                                        @endif
                                    </td>
                                @endforeach
                                <td style="padding: 3px 6px; font-weight: bold; font-size: 0.7rem;">{{$drop['total_pieces_shipped']}}</td>
                            </tr>
                                    @if($columns['Sizes - Price'])
                                        <tr>
                                            <td class="text-end small text-muted">
                                                <a href="/pricing?goTo={{$drop['customer_order_lines']['colourways']['style_versions']['styles_id']}}" class="text-decoration-none">
                                                    Price
                                                </a>
                                            </td>
                                            @foreach($drop['customer_order_lines']['customer_order_line_quantities'] as $size)
                                                @php
                                                    $priceModel = $size['price_model_data'] ?? null;
                                                @endphp
                                                <td class="text-center small @if($priceModel && ($priceModel['quote_status'] ?? "") == "confirmed") text-success fw-bold @elseif($priceModel) text-warning @else text-muted @endif">
                                                    @if($priceModel)
                                                        {{$drop['customer_order_lines']['customer_orders']['customers']['currency'] . number_format($priceModel['quote'] ?? 0, 2)}}
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                            @endforeach
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td class="text-end small text-muted">CMT</td>
                                            @foreach($drop['customer_order_lines']['customer_order_line_quantities'] as $size)
                                                @php
                                                    $priceModel = $size['price_model_data'] ?? null;
                                                @endphp
                                                <td class="text-center small @if($priceModel && ($priceModel['cmt_status'] ?? "") == "confirmed") text-success fw-bold @elseif($priceModel) text-warning @else text-muted @endif">
                                                    @if($priceModel)
                                                        {{$drop['customer_order_lines']['colourways']['style_versions']['factories']['currency'] . number_format($priceModel['cmt'] ?? 0, 2)}}
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                            @endforeach
                                            <td></td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    @endif
                </td>
            @endif
            @if($columns['Total Qty'])
                <td rowspan="2" class="text-center align-middle">
                    <span class="fw-bold">{{ $drop['total_pieces'] }}</span>
                </td>
            @endif
            @if($columns['Total Shipped'])
                <td rowspan="2" class="text-center align-middle">
                    <span class="fw-bold">{{ $drop['total_pieces_shipped'] }}</span>
                </td>
            @endif
            @if($columns['Sealer Sample'])
                <td rowspan="2" class="text-center align-middle">
                    <div class="d-flex flex-column align-items-center">
                        @php
                            $status = Illuminate\Support\Str::title($drop['sealer_sample']['status']);
                            $statusClass = match($status) {
                                'Approved' => 'success',
                                'Rejected' => 'danger',
                                'Required' => 'warning',
                                'Pending' => 'warning',
                                'Not Required' => 'success',
                                default => 'secondary'
                            };
                        @endphp
                        <span class="badge bg-{{ $statusClass }} mb-1">{{ $status }}</span>
                        @if($drop['sealer_sample']['date_sent'])
                            <small class="text-muted">{{date("d-M", strtotime($drop['sealer_sample']['date_sent']))}}</small>
                        @endif
                        @if($drop['sealer_sample']['note'])
                            <small class="text-muted">{{$drop['sealer_sample']['note']}}</small>
                        @endif
                        @if($drop['sealer_sample']['comments'])
                            <small class="text-muted">{{$drop['sealer_sample']['comments']}}</small>
                        @endif
                    </div>
                </td>
            @endif
            @if($columns['Shipment Sample'])
                <td rowspan="2" class="text-center align-middle">
                    <div class="d-flex flex-column align-items-center">
                        @php
                            $status = Illuminate\Support\Str::title($drop['shipment_sample']['status']);
                            $statusClass = match($status) {
                                'Approved' => 'success',
                                'Rejected' => 'danger',
                                'Required' => 'warning',
                                'Pending' => 'warning',
                                'Not Required' => 'success',
                                default => 'secondary'
                            };
                        @endphp
                        <span class="badge bg-{{ $statusClass }} mb-1">{{ $status }}</span>
                        @if($drop['shipment_sample']['date_sent'])
                            <small class="text-muted">{{date("d-M", strtotime($drop['shipment_sample']['date_sent']))}}</small>
                        @endif
                        @if($drop['shipment_sample']['note'])
                            <small class="text-muted">{{$drop['shipment_sample']['note']}}</small>
                        @endif
                        @if($drop['shipment_sample']['comments'])
                            <small class="text-muted">{{$drop['shipment_sample']['comments']}}</small>
                        @endif
                    </div>
                </td>
            @endif
            @if($columns['ExFty'])
                <td rowspan="2" class="text-center align-middle cursor-pointer" 
                    wire:click="toggleExftyHistory({{ $drop['id'] }})"
                    title="Click to view exfty history">
                    @if($showingHistoryFor === $drop['id'] && count($exftyHistory) > 0)
                        <!-- Show history list in single line -->
                        <div class="exfty-history-single-line">
                            @foreach($exftyHistory as $index => $change)
                                @if($change->new_exfty)
                                    <span class="{{ $index === count($exftyHistory) - 1 ? 'fw-bold text-success' : 'text-muted' }}">
                                        {{ date_format(date_create($change->new_exfty), "d M") }}
                                    </span>
                                    @if($index < count($exftyHistory) - 1)
                                        <span class="text-muted mx-1">→</span>
                                    @endif
                                @endif
                            @endforeach
                        </div>
                    @else
                        <!-- Show first exfty -->
                        @if(!empty($drop['first_exfty']))
                            <div class="fw-bold fs-4 text-dark">{{ date_format(date_create($drop['first_exfty']), "d") }}</div>
                            <div class="fw-bold text-dark">{{ date_format(date_create($drop['first_exfty']), "M") }}</div>
                            <small class="text-muted">{{ date_format(date_create($drop['first_exfty']), "Y") }}</small>
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    @endif
                </td>
            @endif
            @if($columns['Revised ExFty'])
                <td rowspan="2" class="text-center align-middle" x-data="{ showInput: false }" x-on:click.away="showInput = false">
                    <div x-show="!showInput" x-on:click="showInput = true" class="cursor-pointer">
                        @if(!empty($drop['exfty']))
                            <div class="fw-bold fs-4 text-dark">{{ date_format(date_create($drop['exfty']), "d") }}</div>
                            <div class="fw-bold text-dark">{{ date_format(date_create($drop['exfty']), "M") }}</div>
                            <small class="text-muted">{{ date_format(date_create($drop['exfty']), "Y") }}</small>
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </div>
                    <div x-show="showInput">
                        <input type="date" 
                               class="form-control form-control-sm text-center"
                               value="{{ $drop['exfty'] ? date('Y-m-d', strtotime($drop['exfty'])) : '' }}"
                               x-on:change="$wire.updateRevisedExfty({{ $drop['id'] }}, $event.target.value); showInput = false"
                               x-on:blur="showInput = false"
                               x-on:keydown.enter="$event.target.blur()"
                               x-on:keydown.escape="showInput = false"
                               style="min-width: 120px;">
                    </div>
                </td>
            @endif
            @if($columns['Customer exFty'])
                <td rowspan="2" class="text-center align-middle" x-data="{ showInput: false }" x-on:click.away="showInput = false">
                    <div x-show="!showInput" x-on:click="showInput = true" class="cursor-pointer">
                        @if(!empty($drop['customer_order_lines']['factory_cust_date']))
                            <div class="fw-bold fs-4 text-dark">{{ date_format(date_create($drop['customer_order_lines']['factory_cust_date']), "d") }}</div>
                            <div class="fw-bold text-dark">{{ date_format(date_create($drop['customer_order_lines']['factory_cust_date']), "M") }}</div>
                            <small class="text-muted">{{ date_format(date_create($drop['customer_order_lines']['factory_cust_date']), "Y") }}</small>
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </div>
                    <div x-show="showInput">
                        <input type="date" 
                               class="form-control form-control-sm text-center"
                               value="{{ $drop['customer_order_lines']['factory_cust_date'] ? date('Y-m-d', strtotime($drop['customer_order_lines']['factory_cust_date'])) : '' }}"
                               x-on:change="$wire.updateExftyDate({{ $drop['id'] }}, $event.target.value); showInput = false"
                               x-on:blur="showInput = false"
                               x-on:keydown.enter="$event.target.blur()"
                               x-on:keydown.escape="showInput = false"
                               style="min-width: 120px;">
                    </div>
                </td>
            @endif
            @if($columns['Customer Into w/h'])
                <td rowspan="2" class="text-center align-middle" x-data="{ showInput: false }" x-on:click.away="showInput = false">
                    <div x-show="!showInput" x-on:click="showInput = true" class="cursor-pointer">
                        @if(!empty($drop['customer_order_lines']['wh_cust_date']))
                            <div class="fw-bold fs-4 text-dark">{{ date_format(date_create($drop['customer_order_lines']['wh_cust_date']), "d") }}</div>
                            <div class="fw-bold text-dark">{{ date_format(date_create($drop['customer_order_lines']['wh_cust_date']), "M") }}</div>
                            <small class="text-muted">{{ date_format(date_create($drop['customer_order_lines']['wh_cust_date']), "Y") }}</small>
                        @else
                            <span class="text-muted">-</span>
                        @endif
                    </div>
                    <div x-show="showInput">
                        <input type="date" 
                               class="form-control form-control-sm text-center"
                               value="{{ $drop['customer_order_lines']['wh_cust_date'] ? date('Y-m-d', strtotime($drop['customer_order_lines']['wh_cust_date'])) : '' }}"
                               x-on:change="$wire.updateCustomerDate({{ $drop['id'] }}, $event.target.value); showInput = false"
                               x-on:blur="showInput = false"
                               x-on:keydown.enter="$event.target.blur()"
                               x-on:keydown.escape="showInput = false"
                               style="min-width: 120px;">
                    </div>
                </td>
            @endif
            @if($columns['Total CMT'])
                <td rowspan="2" class="text-center align-middle">
                    <div class="fw-bold text-danger">{{$drop['customer_order_lines']['colourways']['style_versions']['factories']['currency']}}{{number_format($drop['total_prices']['subtotal'], 2)}}</div>
                </td>
            @endif
            @if($columns['Total Sale'])
                <td rowspan="2" class="text-center align-middle">
                    <div class="fw-bold text-success">{{$drop['customer_order_lines']['customer_orders']['customers']['currency']}}{{number_format($drop['total_prices']['quote'], 2)}}</div>
                </td>
            @endif
            @if($columns['Transport Budget'])
                <td rowspan="2" class="text-center align-middle">
                    <div class="fw-bold text-dark">£{{number_format($drop['total_prices']['transport_budget'], 2)}}</div>
                </td>
            @endif
            @if($columns['Incoterms'])
                <td rowspan="2" class="text-center align-middle">
                    <span class="badge bg-light text-dark">{{$drop['customer_order_lines']['customer_orders']['incoterms']}}</span>
                </td>
            @endif
            @if($columns['Truck'])
                <td rowspan="2" class="text-center align-middle" style="cursor: pointer" x-data="{ showSelect: false }" x-on:click="showSelect = true" x-on:click.away="showSelect = false">
                    <div x-show="!showSelect">
                        @if($drop['shipment_id'])
                            <div class="fw-bold text-primary">{{$drop['shipment_id']}}</div>
                            @if($drop['shipments']['transporters']['name'])
                                <small class="text-muted">{{$drop['shipments']['transporters']['name']}}</small>
                            @endif
                        @else
                            <span class="text-muted">No Shipment</span>
                        @endif
                    </div>
                    
                    <select x-show="showSelect" 
                            class="form-select form-select-sm" 
                            x-on:change="$wire.updateTruck({{ $drop['id'] }}, $event.target.value); showSelect = false"
                            x-on:blur="showSelect = false"
                            x-on:keydown.escape="showSelect = false">
                        <option value="">No Truck</option>
                        @foreach($this->getAvailableTrucks() as $truck)
                            <option value="{{ $truck['id'] }}" @if($drop['shipment_id'] == $truck['id']) selected @endif>
                                {{ $truck['id'] }} @if($truck['transporter_name']) - {{ $truck['transporter_name'] }} @endif
                            </option>
                        @endforeach
                    </select>
                </td>
            @endif
            @if($columns['Collection'])
                <td rowspan="2" class="align-middle">
                    <div class="d-flex flex-column">
                        @if(!empty($drop['collection_date']))
                            <div class="fw-bold">{{ date_format(date_create($drop['collection_date']), "d-M") }}</div>
                            <small class="text-muted">{{ date_format(date_create($drop['collection_date']), "Y") }}</small>
                        @endif
                        
                        <div class="mt-3">
                            <div class="mb-2">
                                <input class="form-control form-control-sm" type="text" wire:model.blur="drops.{{$d}}.net_weight" placeholder="Net Weight">
                            </div>
                            <div class="mb-2">
                                <input class="form-control form-control-sm" type="text" wire:model.blur="drops.{{$d}}.gross_weight" placeholder="Gross Weight">
                            </div>
                            <div class="mb-2">
                                <input class="form-control form-control-sm" type="text" wire:model.blur="drops.{{$d}}.no_cartons" placeholder="Cartons">
                            </div>
                        </div>
                    </div>
                </td>
            @endif
            @if($columns['Customs ERN'])
                <td rowspan="2" class="text-center align-middle">
                    @if(!empty($drop['shipments']['customs_submitted_text']))
                        <span class="badge bg-info">{{$drop['shipments']['customs_submitted_text']}}</span>
                    @else
                        <span class="text-muted">-</span>
                    @endif
                </td>
            @endif
            @if($columns['Shipped'])
                <td rowspan="2" class="text-center align-middle">
                    <div class="form-check d-flex justify-content-center">
                        <input type="checkbox" 
                            class="form-check-input" 
                            style="transform: scale(1.2);"
                            @if($drop['complete']) checked @endif
                            x-data="{ fieldValue: {{ $drop['complete'] ? 'true' : 'false' }} }"
                            x-model="fieldValue"
                            x-on:change.debounce.500ms="$wire.updateShipmentComplete({{ $drop['id'] }}, fieldValue)">
                    </div>
                </td>
            @endif
            @if($columns['RT Invoice'])
                <td class="align-top" style="min-width: 200px; height: 120px;" rowspan="2">
                    <div class="d-flex flex-column gap-2" style="height: 100%;">
                        <!-- RT Invoice -->
                        <div class="d-flex align-items-center gap-2">
                            <label class="small text-muted" style="min-width: 60px;">RT:</label>
                            @can('finance:update')
                                <input class="form-control form-control-sm" type="text" wire:model.blur="drops.{{$d}}.rt_invoice" placeholder="RT Invoice" style="background: white; border: 1px solid #dee2e6; outline: none; box-shadow: none;">
                            @else
                                <span class="text-muted small">{{$drop['rt_invoice'] ?: '-'}}</span>
                            @endcan
                        </div>
                        
                        <!-- Factory Invoice -->
                        <div class="d-flex align-items-center gap-2">
                            <label class="small text-muted" style="min-width: 60px;">Factory:</label>
                            @can('finance:update')
                                <input class="form-control form-control-sm" type="text" wire:model.blur="drops.{{$d}}.factory_invoice" placeholder="Factory Invoice" style="background: white; border: 1px solid #dee2e6; outline: none; box-shadow: none;">
                            @else
                                <span class="text-muted small">{{$drop['factory_invoice'] ?: '-'}}</span>
                            @endcan
                        </div>
                        
                        <!-- Customs Invoice -->
                        <div class="d-flex align-items-center gap-2">
                            <label class="small text-muted" style="min-width: 60px;">Customs:</label>
                            @can('finance:update')
                                <input class="form-control form-control-sm" type="text" wire:model.blur="drops.{{$d}}.customs_agency_invoice" placeholder="Customs Invoice" style="background: white; border: 1px solid #dee2e6; outline: none; box-shadow: none;">
                            @else
                                <span class="text-muted small">{{$drop['customs_agency_invoice'] ?: '-'}}</span>
                            @endcan
                        </div>
                        
                        <!-- Transporter Invoice -->
                        <div class="d-flex align-items-center gap-2">
                            <label class="small text-muted" style="min-width: 60px;">Transport:</label>
                            @if($drop['shipments'])
                                @can('finance:update')
                                    <input class="form-control form-control-sm" type="text" wire:model.blur="drops.{{$d}}.shipments.transporter_invoice" placeholder="Transporter Invoice" style="background: white; border: 1px solid #dee2e6; outline: none; box-shadow: none;">
                                @else
                                    <span class="text-muted small">{{$drop['shipments']['transporter_invoice'] ?: '-'}}</span>
                                @endcan
                            @else
                                <span class="text-muted small">-</span>
                            @endif
                        </div>
                    </div>
                </td>
            @endif
            @if($columns['RT Invoice'])
                <td class="align-top" style="min-width: 200px; height: 120px;" rowspan="2">
                    <div class="d-flex flex-column gap-2" style="height: 100%;">
                        <!-- Finance Complete -->
                        <div class="d-flex align-items-center gap-2">
                            <label class="small text-muted" style="min-width: 60px;">Complete:</label>
                            @can('finance:update')
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" wire:model.blur="drops.{{$d}}.invoiced" style="transform: scale(1.1);">
                                </div>
                            @else
                                <span class="badge {{$drop['invoiced'] ? 'bg-success' : 'bg-warning'}} small">
                                    {{$drop['invoiced'] ? 'Yes' : 'No'}}
                                </span>
                            @endcan
                        </div>
                        
                        <!-- Finance Notes -->
                        <div class="d-flex flex-column gap-1" style="flex-grow: 1;">
                            @if(Gate::check('finance:update'))
                                <textarea
                                    rows="4"
                                    class="form-control form-control-sm fw-bold text-danger"
                                    placeholder="Add finance notes..."
                                    wire:model.blur="drops.{{$d}}.fn_notes"
                                    style="height: 111px; background: white; border: 1px solid #dee2e6; outline: none; box-shadow: none; resize: vertical; flex-grow: 1;">
                                </textarea>
                            @else
                                <div class="text-muted d-flex align-items-center" style="flex-grow: 1;">{{$drop['fn_notes'] ?: 'No finance notes'}}</div>
                            @endif
                        </div>
                    </div>
                </td>
            @endif
        </tr>
        <tr
            class="
                @if($drop['flag_issue']) bg-issue
                @elseif($drop['customer_order_lines']['cancelled']) bg-red
                @elseif($drop['complete']) shipped
                @elseif(($drop['shipment_status'] ?? $drop['shipment_sample']['status']) == 'approved' || ($drop['shipment_sample']['status'] == "Not Required" && $drop['sealer_sample']['status'] == "Not Required")) bg-good
                @elseif($drop['shipment_sample']['status'] == 'rejected') bg-issue
                @endif

                @if($drop['customer_order_lines']['colourways']['style_versions']['styles']['cancelled'] || $drop['customer_order_lines']['colourways']['cancelled']) ss_cancelled @endif
            "
            style="
                @if($this->chunk[$d]['is_last_in_shipment']) border-bottom: 3px solid #000 !important;
                @else border-bottom: 1px solid #000 !important; @endif

            " >
            @if($this->notesColsCount() != 0)
                <td colspan="{{$this->notesColsCount()}}" class="align-middle">
                    @if(Gate::check('style:update') || Gate::check('order:update'))
                        <textarea
                            rows="2"
                            class="form-control form-control-sm fw-bold text-danger"
                            placeholder="Add notes..."
                            wire:model.blur="drops.{{$d}}.notes"
                            style="background: transparent; border: none; resize: none; outline: none; box-shadow: none;">
                        </textarea>
                    @else
                        <div class="text-muted">{{$drop['notes'] ?: 'No notes'}}</div>
                    @endif
                </td>
            @endif
        </tr>
    @endforeach
</tbody>

