<div>
@push('structured_data')
<script type="application/ld+json">
{
  "@context": "https://schema.org/",
  "@type": "Product",
  "name": "{{ $product->name }}",
  "description": "{{ $product->short_description ?? $product->description }}",
  "sku": "{{ $product->sku }}",
  "brand": {
    "@type": "Brand",
    "name": "Robert Todd Yarn"
  },
  @if($product->primary_image)
  "image": "{{ Storage::url($product->primary_image) }}",
  @endif
  "offers": {
    "@type": "Offer",
    "price": "{{ $product->price }}",
    "priceCurrency": "GBP",
    "availability": "https://schema.org/InStock"
  }
}
</script>
@endpush

<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb ys-breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('shop.all') }}">Shop</a></li>
                @if($product->season)
                    <li class="breadcrumb-item"><a href="{{ route('shop.season', $product->season->slug) }}">{{ $product->season->name }}</a></li>
                @endif
                @if($product->category)
                    <li class="breadcrumb-item"><a href="{{ route('shop.category', $product->category->slug) }}">{{ $product->category->name }}</a></li>
                @endif
                <li class="breadcrumb-item active">{{ $product->name }}</li>
            </ol>
        </nav>
    </div>
</div>

<div class="container py-5">
    @if(session('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Product Images -->
        <div class="col-lg-6 mb-4 mb-lg-0">
            <div class="ys-card p-3">
                @if($product->images && count($product->images) > 0)
                    <div class="mb-3">
                        <img src="{{ Storage::url($product->images[0]) }}" 
                             alt="{{ $product->name }}" 
                             class="w-100 rounded" 
                             style="max-height: 500px; object-fit: contain;">
                    </div>
                    
                    @if(count($product->images) > 1)
                        <div class="d-flex gap-2 overflow-auto">
                            @foreach($product->images as $image)
                                <img src="{{ Storage::url($image) }}" 
                                     alt="{{ $product->name }}" 
                                     class="rounded cursor-pointer" 
                                     style="width: 80px; height: 80px; object-fit: cover; opacity: 0.7; transition: opacity 0.2s;"
                                     onmouseover="this.style.opacity='1'"
                                     onmouseout="this.style.opacity='0.7'">
                            @endforeach
                        </div>
                    @endif
                @else
                    <div class="d-flex align-items-center justify-content-center bg-secondary text-white rounded" 
                         style="height: 500px;">
                        <span>No Image Available</span>
                    </div>
                @endif
            </div>

            <!-- Colourways -->
            @if($product->colourways->count() > 0)
                <div class="ys-card p-4 mt-3">
                    <h5 class="fw-bold mb-3">Available Colourways</h5>
                    <div class="row g-2">
                        @foreach($product->colourways as $colourway)
                            <div class="col-4 col-md-3">
                                <div class="cursor-pointer text-center p-2 rounded {{ $selectedColourway == $colourway->id ? 'border-2' : 'border' }}"
                                     wire:click="$set('selectedColourway', {{ $colourway->id }})"
                                     style="border-color: {{ $selectedColourway == $colourway->id ? 'var(--ys-primary)' : 'var(--ys-border)' }} !important;">
                                    @if($colourway->image)
                                        <img src="{{ Storage::url($colourway->image) }}" 
                                             alt="{{ $colourway->reference }}" 
                                             class="w-100 rounded mb-2"
                                             style="height: 80px; object-fit: cover;">
                                    @endif
                                    <small class="d-block">{{ $colourway->reference }}</small>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>

        <!-- Product Details -->
        <div class="col-lg-6">
            <div class="ys-card p-4">
                <div class="d-flex gap-2 mb-3">
                    @if($product->season)
                        <span class="badge badge-ys-primary">{{ $product->season->name }}</span>
                    @endif
                    @if($product->category)
                        <span class="badge badge-ys-accent">{{ $product->category->name }}</span>
                    @endif
                </div>

                <h1 class="fw-bold mb-3">{{ $product->name }}</h1>
                
                @if($product->sku)
                    <p class="text-muted mb-3"><small>SKU: {{ $product->sku }}</small></p>
                @endif

                <div class="mb-4">
                    <span class="h2 fw-bold" style="color: var(--ys-primary);">{{ $product->formatted_price }}</span>
                    <small class="text-muted ms-2">per ball</small>
                </div>

                @if($product->short_description)
                    <p class="lead mb-4">{{ $product->short_description }}</p>
                @endif

                <!-- Add to Basket Form -->
                <div class="mb-4 p-3 rounded" style="background-color: var(--ys-bg-section);">
                    <div class="mb-3">
                        <label class="form-label fw-semibold">Quantity</label>
                        <div class="input-group" style="max-width: 150px;">
                            <button class="btn btn-outline-secondary" wire:click="decrementQuantity" type="button">-</button>
                            <input type="text" class="form-control text-center" value="{{ $quantity }}" readonly>
                            <button class="btn btn-outline-secondary" wire:click="incrementQuantity" type="button">+</button>
                        </div>
                    </div>

                    <button wire:click="addToBasket" class="btn btn-ys-primary btn-lg w-100">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-2">
                            <circle cx="9" cy="21" r="1"></circle>
                            <circle cx="20" cy="21" r="1"></circle>
                            <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path>
                        </svg>
                        Add to Basket
                    </button>
                </div>

                <!-- Product Description -->
                @if($product->description)
                    <div class="mb-4">
                        <h5 class="fw-bold mb-2">Description</h5>
                        <p>{{ $product->description }}</p>
                    </div>
                @endif

                <!-- Specifications -->
                @if($product->specifications && count($product->specifications) > 0)
                    <div>
                        <h5 class="fw-bold mb-3">Specifications</h5>
                        <table class="table">
                            <tbody>
                                @foreach($product->specifications as $key => $value)
                                    <tr>
                                        <td class="fw-semibold">{{ ucfirst(str_replace('_', ' ', $key)) }}</td>
                                        <td>{{ $value }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Related Products -->
    @if($relatedProducts->count() > 0)
        <div class="mt-5">
            <h3 class="fw-bold mb-4">You May Also Like</h3>
            <div class="row g-4">
                @foreach($relatedProducts as $related)
                    <div class="col-lg-3 col-md-6">
                        <div class="product-card">
                            <a href="{{ route('product.show', $related->slug) }}" class="text-decoration-none">
                                @if($related->primary_image)
                                    <img src="{{ Storage::url($related->primary_image) }}" 
                                         alt="{{ $related->name }}"
                                         loading="lazy">
                                @else
                                    <div class="d-flex align-items-center justify-content-center bg-secondary text-white" 
                                         style="height: 300px;">
                                        <span>No Image</span>
                                    </div>
                                @endif
                                
                                <div class="p-3">
                                    <h5 class="fw-bold mb-2" style="color: var(--ys-text-primary);">
                                        {{ $related->name }}
                                    </h5>
                                    
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fw-bold h5 mb-0" style="color: var(--ys-primary);">
                                            {{ $related->formatted_price }}
                                        </span>
                                        <span class="btn btn-sm btn-ys-primary">View</span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    @endif
</div>
</div>

