<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LibraryTrack extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id', 'title', 'slug', 'duration_sec', 'audio_path', 'transcript_path', 'tags', 'published_at',
    ];

    protected $casts = [
        'tags' => 'array',
        'published_at' => 'datetime',
    ];

    public function category()
    {
        return $this->belongsTo(LibraryCategory::class, 'category_id');
    }
}


