@extends('layouts.frontend')

@section('meta_title', 'Cookie Policy - Yarn Store')
@section('meta_description', 'Learn about how Yarn Store uses cookies and similar technologies on our website.')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <h1 class="display-5 fw-bold mb-4">Cookie Policy</h1>
            <p class="text-muted mb-5">Last updated: {{ date('F d, Y') }}</p>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">1. What Are Cookies?</h2>
                <p class="text-muted">
                    Cookies are small text files that are placed on your device when you visit our website. They help us 
                    provide you with a better experience by remembering your preferences and understanding how you use our site.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">2. How We Use Cookies</h2>
                
                <h3 class="h6 fw-semibold mb-2">Necessary Cookies (Always Active)</h3>
                <p class="text-muted mb-3">
                    These cookies are essential for the website to function properly. They enable core functionality such as:
                </p>
                <ul class="text-muted mb-4">
                    <li>Maintaining your session and login status</li>
                    <li>Storing items in your shopping basket</li>
                    <li>Security and fraud prevention</li>
                    <li>Remembering your cookie preferences</li>
                </ul>

                <h3 class="h6 fw-semibold mb-2">Performance & Analytics Cookies</h3>
                <p class="text-muted mb-3">
                    These cookies help us understand how visitors interact with our website by collecting and reporting 
                    information anonymously. This includes:
                </p>
                <ul class="text-muted mb-4">
                    <li>Number of visitors to the site</li>
                    <li>Pages visited and time spent on each page</li>
                    <li>How you arrived at the site</li>
                    <li>Technical information about your device and browser</li>
                </ul>
                <p class="text-muted">
                    We use Google Analytics for this purpose. You can opt out of these cookies through our cookie consent banner.
                </p>

                <h3 class="h6 fw-semibold mb-2">Functionality Cookies</h3>
                <p class="text-muted mb-3">
                    These cookies allow us to remember choices you make and provide enhanced features:
                </p>
                <ul class="text-muted">
                    <li>Remembering your language preference</li>
                    <li>Recognizing when you return to the site</li>
                    <li>Saving your preferences and settings</li>
                </ul>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">3. Cookies We Use</h2>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Cookie Name</th>
                                <th>Purpose</th>
                                <th>Duration</th>
                                <th>Type</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><code>cookie_consent</code></td>
                                <td>Stores your cookie preferences</td>
                                <td>1 year</td>
                                <td>Necessary</td>
                            </tr>
                            <tr>
                                <td><code>basket</code></td>
                                <td>Stores items in your shopping basket</td>
                                <td>30 days</td>
                                <td>Necessary</td>
                            </tr>
                            <tr>
                                <td><code>XSRF-TOKEN</code></td>
                                <td>Security token to prevent cross-site request forgery</td>
                                <td>Session</td>
                                <td>Necessary</td>
                            </tr>
                            <tr>
                                <td><code>laravel_session</code></td>
                                <td>Maintains your session on the website</td>
                                <td>Session</td>
                                <td>Necessary</td>
                            </tr>
                            <tr>
                                <td><code>_ga</code></td>
                                <td>Google Analytics - distinguishes users</td>
                                <td>2 years</td>
                                <td>Analytics</td>
                            </tr>
                            <tr>
                                <td><code>_gid</code></td>
                                <td>Google Analytics - distinguishes users</td>
                                <td>24 hours</td>
                                <td>Analytics</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">4. Managing Your Cookie Preferences</h2>
                <p class="text-muted mb-3">
                    You can control and manage cookies in several ways:
                </p>
                
                <h3 class="h6 fw-semibold mb-2">Our Cookie Banner</h3>
                <p class="text-muted mb-3">
                    When you first visit our website, you'll see a cookie consent banner. You can choose to accept all cookies 
                    or only necessary ones. You can change your preferences at any time by clicking the button below:
                </p>
                <button class="btn btn-ys-primary mb-4" onclick="document.cookie='cookie_consent=; expires=Thu, 01 Jan 1970 00:00:00 UTC; path=/;'; location.reload();">
                    Update Cookie Preferences
                </button>

                <h3 class="h6 fw-semibold mb-2">Browser Settings</h3>
                <p class="text-muted mb-3">
                    Most web browsers allow you to control cookies through their settings. You can usually find these settings in 
                    the "Options" or "Preferences" menu. Please note that blocking all cookies may impact your experience on our site.
                </p>

                <h3 class="h6 fw-semibold mb-2">Third-Party Opt-Out</h3>
                <p class="text-muted">
                    For Google Analytics, you can install the <a href="https://tools.google.com/dlpage/gaoptout" target="_blank" class="text-primary">Google Analytics Opt-out Browser Add-on</a>.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">5. Changes to This Cookie Policy</h2>
                <p class="text-muted">
                    We may update this Cookie Policy from time to time to reflect changes in technology, legislation, or our 
                    business practices. We will post any changes on this page with an updated "Last updated" date.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">6. More Information</h2>
                <p class="text-muted mb-3">
                    For more information about how we handle your personal data, please see our <a href="{{ route('privacy') }}" class="text-primary">Privacy Policy</a>.
                </p>
                <p class="text-muted mb-3">
                    If you have any questions about our use of cookies, please contact us:
                </p>
                <a href="{{ route('contact') }}" class="btn btn-ys-primary">
                    Contact Us
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

