<?php

namespace App\Models;

use Bkwld\Cloner\Cloneable;
use App\Models\BaseModel;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Services\TotalCacheService;

class ShipmentLineSizes extends BaseModel
{
    use SoftDeletes;
    use HasFactory;
    use Cloneable;
    protected $casts = [
        'qty'         => 'integer',
        'shipped_qty' => 'integer',
        'created_at'  => 'datetime:Y-m-d',
        'updated_at'  => 'datetime:Y-m-d',
        'deleted_at'  => 'datetime:Y-m-d',
    ];
	protected $fillable = [
        'sizes_id',
        'shipment_line_id',
        'qty',
        'created_at',
        'updated_at',
        'shipped_qty',
        'deleted_at',
    ];



    public function sizes()
    {
        return $this->belongsTo(Sizes::class);
    }
    public function shipment_lines()
    {
        return $this->belongsTo(ShipmentLine::class);
    }
}
