<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\Favorite;
use App\Models\Track;
use Illuminate\Http\Request;

class FavoritesController extends Controller
{
    public function toggle(Request $request, Track $track)
    {
        $user = $request->user();
        $exists = Favorite::query()->where('user_id', $user->id)->where('track_id', $track->id)->exists();
        if ($exists) {
            Favorite::query()->where('user_id', $user->id)->where('track_id', $track->id)->delete();
            return response()->json(['status' => 'removed']);
        }
        Favorite::create([
            'user_id' => $user->id,
            'track_id' => $track->id,
            'created_at' => now(),
        ]);
        return response()->json(['status' => 'added']);
    }
}


