@extends('layouts.shop')

@section('title', 'Frequently Asked Questions - Yarn Store')
@section('meta_description', 'Find answers to common questions about ordering, shipping, returns, and yarn care at Yarn Store.')

@section('content')
<div class="py-4" style="background-color: var(--ys-bg-section);">
    <div class="container">
        <h1 class="fw-bold mb-0">Frequently Asked Questions</h1>
    </div>
</div>

<div class="container py-5">
    <div class="row">
        <div class="col-lg-9 mx-auto">
            <!-- Ordering -->
            <div class="ys-card p-4 mb-4">
                <h3 class="fw-bold mb-4">Ordering</h3>
                
                <h5 class="fw-bold mb-2">How do I place an order?</h5>
                <p class="mb-4">Browse our products, add items to your basket, and proceed to checkout. You'll need to create an account or checkout as a guest.</p>

                <h5 class="fw-bold mb-2">Can I modify my order after placing it?</h5>
                <p class="mb-4">Please contact us immediately at info@yarnstore.co.uk. We'll do our best to accommodate changes before dispatch.</p>

                <h5 class="fw-bold mb-2">What payment methods do you accept?</h5>
                <p class="mb-4">We accept all major credit/debit cards (Visa, Mastercard, American Express) and PayPal.</p>
            </div>

            <!-- Shipping -->
            <div class="ys-card p-4 mb-4">
                <h3 class="fw-bold mb-4">Shipping & Delivery</h3>
                
                <h5 class="fw-bold mb-2">Do you offer free shipping?</h5>
                <p class="mb-4">Yes! We offer free UK delivery on all orders over £50. Orders under £50 have a flat £5 shipping fee.</p>

                <h5 class="fw-bold mb-2">How long does delivery take?</h5>
                <p class="mb-4">UK orders typically arrive within 2-4 business days. International shipping times vary by destination.</p>

                <h5 class="fw-bold mb-2">Do you ship internationally?</h5>
                <p class="mb-4">Yes, we ship worldwide. International shipping costs are calculated at checkout.</p>

                <h5 class="fw-bold mb-2">Can I track my order?</h5>
                <p class="mb-4">Yes! You'll receive a tracking number via email once your order ships. You can also track orders through your account.</p>
            </div>

            <!-- Returns -->
            <div class="ys-card p-4 mb-4">
                <h3 class="fw-bold mb-4">Returns & Exchanges</h3>
                
                <h5 class="fw-bold mb-2">What is your return policy?</h5>
                <p class="mb-4">We accept returns within 14 days of delivery. Items must be unused, in original packaging, with labels attached.</p>

                <h5 class="fw-bold mb-2">How do I return an item?</h5>
                <p class="mb-4">Contact us at info@yarnstore.co.uk for a return authorization. We'll provide return instructions and address.</p>

                <h5 class="fw-bold mb-2">Who pays for return shipping?</h5>
                <p class="mb-4">Customers are responsible for return shipping costs unless the item is defective or we made an error.</p>

                <h5 class="fw-bold mb-2">When will I receive my refund?</h5>
                <p class="mb-4">Refunds are processed within 5-7 business days after we receive your return.</p>
            </div>

            <!-- Products -->
            <div class="ys-card p-4 mb-4">
                <h3 class="fw-bold mb-4">Product Questions</h3>
                
                <h5 class="fw-bold mb-2">How much yarn do I need for my project?</h5>
                <p class="mb-4">This depends on your project size and pattern. Check pattern requirements and always buy 10% extra.</p>

                <h5 class="fw-bold mb-2">Can you match dye lots if I need more?</h5>
                <p class="mb-4">We try our best, but dye lots can vary. We recommend buying all yarn needed for your project at once.</p>

                <h5 class="fw-bold mb-2">Do you offer yarn samples?</h5>
                <p class="mb-4">Currently, we don't offer samples. However, product descriptions include detailed information about each yarn.</p>

                <h5 class="fw-bold mb-2">Can I substitute yarns in a pattern?</h5>
                <p class="mb-4">Yes, but ensure the substitute matches the weight and gauge of the original. Contact us for advice!</p>
            </div>

            <!-- Account -->
            <div class="ys-card p-4 mb-4">
                <h3 class="fw-bold mb-4">Account & Orders</h3>
                
                <h5 class="fw-bold mb-2">Do I need an account to order?</h5>
                <p class="mb-4">No, you can checkout as a guest. However, an account lets you track orders and save addresses.</p>

                <h5 class="fw-bold mb-2">How do I reset my password?</h5>
                <p class="mb-4">Click "Forgot Password" on the login page and follow the instructions sent to your email.</p>

                <h5 class="fw-bold mb-2">How do I update my account information?</h5>
                <p class="mb-4">Log in and visit "My Account" to update your details, addresses, and preferences.</p>
            </div>

            <!-- Contact -->
            <div class="text-center p-5" style="background-color: var(--ys-bg-section); border-radius: 0.5rem;">
                <h3 class="fw-bold mb-3">Still Have Questions?</h3>
                <p class="text-muted mb-4">Our customer service team is here to help</p>
                <div class="d-flex gap-3 justify-content-center flex-wrap">
                    <a href="{{ route('contact') }}" class="btn btn-ys-primary">Contact Us</a>
                    <a href="mailto:info@yarnstore.co.uk" class="btn btn-outline-primary">Email Us</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


