import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';
import typography from '@tailwindcss/typography';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Inter', 'Quicksand', ...defaultTheme.fontFamily.sans],
                heading: ['Quicksand', 'Nunito', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                primary: {
                    50:  '#f3faf7',
                    100: '#e6f6f1',
                    200: '#ccece3',
                    300: '#b3e3d6',
                    400: '#80d0bb',
                    500: '#4dbda0', // main brand green-teal
                    600: '#3e9780',
                    700: '#2f7160',
                    800: '#204b40',
                    900: '#102520',
                },
                accent: {
                    50:  '#f5f8fa',
                    100: '#eaf2f5',
                    200: '#d4e4eb',
                    300: '#bfd7e0',
                    400: '#94bccb',
                    500: '#6aa1b6', // soft blue accent
                    600: '#558194',
                    700: '#406072',
                    800: '#2b404f',
                    900: '#15202d',
                },
                neutral: {
                    50:  '#fafafa',
                    100: '#f5f5f5',
                    200: '#e5e5e5',
                    300: '#d4d4d4',
                    400: '#a3a3a3',
                    500: '#737373',
                    600: '#525252',
                    700: '#404040',
                    800: '#262626',
                    900: '#171717',
                }
            },
            letterSpacing: {
                'heading': '0.025em',
            },
            animation: {
                'fadeIn': 'fadeIn 0.5s ease-in-out',
                'fadeInUp': 'fadeInUp 0.6s ease-out',
                'fadeInDown': 'fadeInDown 0.6s ease-out',
            },
            keyframes: {
                fadeIn: {
                    '0%': { opacity: '0' },
                    '100%': { opacity: '1' },
                },
                fadeInUp: {
                    '0%': { opacity: '0', transform: 'translateY(20px)' },
                    '100%': { opacity: '1', transform: 'translateY(0)' },
                },
                fadeInDown: {
                    '0%': { opacity: '0', transform: 'translateY(-20px)' },
                    '100%': { opacity: '1', transform: 'translateY(0)' },
                },
            },
        },
    },

    plugins: [forms, typography],
};
