<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Season;
use App\Models\Category;
use App\Models\Item;

class HomePage extends Component
{
    public function render()
    {
        $featuredSeasons = Season::where('is_active', true)
            ->orderBy('sort_order')
            ->limit(3)
            ->get();

        $featuredCategories = Category::where('is_active', true)
            ->orderBy('sort_order')
            ->limit(6)
            ->get();

        $featuredProducts = Item::where('is_active', true)
            ->with(['season', 'category'])
            ->latest()
            ->limit(8)
            ->get();

        return view('livewire.home-page', [
            'featuredSeasons' => $featuredSeasons,
            'featuredCategories' => $featuredCategories,
            'featuredProducts' => $featuredProducts,
        ])->layout('layouts.shop');
    }
}

