<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Season;
use App\Models\Category;
use App\Models\Item;

class HomePage extends Component
{
    public function render()
    {
        $featuredSeasons = Season::orderBy('sort_order')
            ->limit(3)
            ->get();

        $featuredCategories = Category::orderBy('sort_order')
            ->limit(6)
            ->get();

        $featuredProducts = Item::with(['season', 'category', 'colourways' => function($q) {
                $q->orderBy('sort_order');
            }])
            ->latest()
            ->limit(8)
            ->get();

        return view('livewire.home-page', [
            'featuredSeasons' => $featuredSeasons,
            'featuredCategories' => $featuredCategories,
            'featuredProducts' => $featuredProducts,
        ])->layout('layouts.shop');
    }
}

