-- Migration: Add payment enforcement override field
-- This allows admins to exempt specific users from automatic payment enforcement

-- Add skip_payment_enforcement column
ALTER TABLE users ADD COLUMN IF NOT EXISTS skip_payment_enforcement BOOLEAN NOT NULL DEFAULT FALSE;

-- Add index for queries
CREATE INDEX IF NOT EXISTS idx_users_skip_payment_enforcement ON users(skip_payment_enforcement);

-- Add last_payment_check_at column to track when we last checked payment status
ALTER TABLE users ADD COLUMN IF NOT EXISTS last_payment_check_at TIMESTAMP;

-- Add payment_grace_period_ends column to track when grace period expires
ALTER TABLE users ADD COLUMN IF NOT EXISTS payment_grace_period_ends TIMESTAMP;

-- Add comments
COMMENT ON COLUMN users.skip_payment_enforcement IS 'When true, user is exempt from automatic payment enforcement (admin override)';
COMMENT ON COLUMN users.last_payment_check_at IS 'Last time payment status was checked for enforcement';
COMMENT ON COLUMN users.payment_grace_period_ends IS 'When payment grace period expires (7 days after payment issue detected)';


