<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Colourway extends Model
{
    protected $fillable = [
        'items_id',
        'reference',
        'image',
        'is_active',
        'sort_order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'sort_order' => 'integer',
    ];

    public function item(): BelongsTo
    {
        return $this->belongsTo(Item::class, 'items_id');
    }

    public function getImageUrlAttribute(): ?string
    {
        if ($this->image) {
            return $this->image;
        }
        return null;
    }
}
