<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VatAnalysis extends Model
{
    protected $fillable = [
        'receipt_line_id',
        'jurisdiction',
        'vat_rate',
        'vat_amount_claimable',
        'reasoning',
        'meta',
    ];

    protected $casts = [
        'meta' => 'array',
    ];

    public function receiptLine(): BelongsTo
    {
        return $this->belongsTo(ReceiptLine::class);
    }
}
